/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.DescriptorProtos;
import com.mathworks.google.protobuf.Descriptors;
import com.mathworks.google.protobuf.FieldInfo;
import com.mathworks.google.protobuf.FieldType;
import com.mathworks.google.protobuf.GeneratedMessage;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.Message;
import com.mathworks.google.protobuf.MessageInfo;
import com.mathworks.google.protobuf.MessageInfoFactory;
import com.mathworks.google.protobuf.OneofInfo;
import com.mathworks.google.protobuf.ProtoSyntax;
import com.mathworks.google.protobuf.SchemaUtil;
import com.mathworks.google.protobuf.StructuralMessageInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

final class DescriptorMessageInfoFactory
implements MessageInfoFactory {
    private static final String GET_DEFAULT_INSTANCE_METHOD_NAME = "getDefaultInstance";
    private static final DescriptorMessageInfoFactory instance = new DescriptorMessageInfoFactory();
    private static final Set<String> specialFieldNames = new HashSet<String>(Arrays.asList("Class", "DefaultInstanceForType", "ParserForType", "SerializedSize", "AllFields", "DescriptorForType", "InitializationErrorString", "UnknownFields", "CachedSize"));
    private static IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = new IsInitializedCheckAnalyzer();

    private DescriptorMessageInfoFactory() {
    }

    public static DescriptorMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> clazz) {
        return GeneratedMessage.class.isAssignableFrom(clazz);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> clazz) {
        if (!GeneratedMessage.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unsupported message type: " + clazz.getName());
        }
        return DescriptorMessageInfoFactory.convert(clazz, DescriptorMessageInfoFactory.descriptorForType(clazz));
    }

    private static Message getDefaultInstance(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod(GET_DEFAULT_INSTANCE_METHOD_NAME, new Class[0]);
            return (Message)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to get default instance for message class " + clazz.getName(), exception);
        }
    }

    private static Descriptors.Descriptor descriptorForType(Class<?> clazz) {
        return DescriptorMessageInfoFactory.getDefaultInstance(clazz).getDescriptorForType();
    }

    private static ProtoSyntax convertSyntax(DescriptorProtos.Edition edition) {
        switch (edition) {
            case EDITION_PROTO2: {
                return ProtoSyntax.PROTO2;
            }
            case EDITION_PROTO3: {
                return ProtoSyntax.PROTO3;
            }
        }
        return ProtoSyntax.EDITIONS;
    }

    private static MessageInfo convert(Class<?> clazz, Descriptors.Descriptor descriptor) {
        List<Descriptors.FieldDescriptor> list = descriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(list.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(clazz));
        builder.withSyntax(DescriptorMessageInfoFactory.convertSyntax(descriptor.getFile().getEdition()));
        builder.withMessageSetWireFormat(descriptor.getOptions().getMessageSetWireFormat());
        OneofState oneofState = new OneofState();
        int n = 0;
        int n2 = 1;
        Field field = null;
        for (int i = 0; i < list.size(); ++i) {
            FieldInfo fieldInfo;
            final Descriptors.FieldDescriptor fieldDescriptor = list.get(i);
            boolean bl = fieldDescriptor.needsUtf8Check();
            Internal.EnumVerifier enumVerifier = null;
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && fieldDescriptor.legacyEnumFieldTreatedAsClosed()) {
                enumVerifier = new Internal.EnumVerifier(){

                    @Override
                    public boolean isInRange(int n) {
                        return fieldDescriptor.getEnumType().findValueByNumber(n) != null;
                    }
                };
            }
            if (fieldDescriptor.getRealContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(clazz, fieldDescriptor, oneofState, bl, enumVerifier));
                continue;
            }
            Field field2 = DescriptorMessageInfoFactory.field(clazz, fieldDescriptor);
            int n3 = fieldDescriptor.getNumber();
            FieldType fieldType = DescriptorMessageInfoFactory.getFieldType(fieldDescriptor);
            if (!fieldDescriptor.hasPresence()) {
                if (fieldDescriptor.isMapField()) {
                    final Descriptors.FieldDescriptor fieldDescriptor2 = fieldDescriptor.getMessageType().findFieldByNumber(2);
                    if (fieldDescriptor2.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && fieldDescriptor2.legacyEnumFieldTreatedAsClosed()) {
                        enumVerifier = new Internal.EnumVerifier(){

                            @Override
                            public boolean isInRange(int n) {
                                return fieldDescriptor2.getEnumType().findValueByNumber(n) != null;
                            }
                        };
                    }
                    fieldInfo = FieldInfo.forMapField(field2, n3, SchemaUtil.getMapDefaultEntry(clazz, fieldDescriptor.getName()), enumVerifier);
                } else {
                    fieldInfo = fieldDescriptor.isRepeated() && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? FieldInfo.forRepeatedMessageField(field2, n3, fieldType, DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(clazz, fieldDescriptor)) : (fieldDescriptor.isPacked() ? (enumVerifier != null ? FieldInfo.forPackedFieldWithEnumVerifier(field2, n3, fieldType, enumVerifier, DescriptorMessageInfoFactory.cachedSizeField(clazz, fieldDescriptor)) : FieldInfo.forPackedField(field2, n3, fieldType, DescriptorMessageInfoFactory.cachedSizeField(clazz, fieldDescriptor))) : (enumVerifier != null ? FieldInfo.forFieldWithEnumVerifier(field2, n3, fieldType, enumVerifier) : FieldInfo.forField(field2, n3, fieldType, bl)));
                }
                builder.withField(fieldInfo);
                continue;
            }
            if (field == null) {
                field = DescriptorMessageInfoFactory.bitField(clazz, n);
            }
            fieldInfo = fieldDescriptor.isRequired() ? FieldInfo.forLegacyRequiredField(field2, n3, fieldType, field, n2, bl, enumVerifier) : FieldInfo.forExplicitPresenceField(field2, n3, fieldType, field, n2, bl, enumVerifier);
            builder.withField(fieldInfo);
            if ((n2 <<= 1) != 0) continue;
            field = null;
            n2 = 1;
            ++n;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Descriptors.FieldDescriptor fieldDescriptor = list.get(i);
            if (!fieldDescriptor.isRequired() && (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !DescriptorMessageInfoFactory.needsIsInitializedCheck(fieldDescriptor.getMessageType()))) continue;
            arrayList.add(fieldDescriptor.getNumber());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        if (nArray.length > 0) {
            builder.withCheckInitialized(nArray);
        }
        return builder.build();
    }

    private static boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
        return isInitializedCheckAnalyzer.needsIsInitializedCheck(descriptor);
    }

    private static FieldInfo buildOneofMember(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor, OneofState oneofState, boolean bl, Internal.EnumVerifier enumVerifier) {
        OneofInfo oneofInfo = oneofState.getOneof(clazz, fieldDescriptor.getContainingOneof());
        FieldType fieldType = DescriptorMessageInfoFactory.getFieldType(fieldDescriptor);
        Class<?> clazz2 = DescriptorMessageInfoFactory.getOneofStoredType(clazz, fieldDescriptor, fieldType);
        return FieldInfo.forOneofMemberField(fieldDescriptor.getNumber(), fieldType, oneofInfo, clazz2, bl, enumVerifier);
    }

    private static Class<?> getOneofStoredType(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor, FieldType fieldType) {
        switch (fieldType.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case ENUM: 
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case MESSAGE: {
                return DescriptorMessageInfoFactory.getOneofStoredTypeForMessage(clazz, fieldDescriptor);
            }
        }
        throw new IllegalArgumentException("Invalid type for oneof: " + (Object)((Object)fieldType));
    }

    private static FieldType getFieldType(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.BOOL;
                }
                return fieldDescriptor.isPacked() ? FieldType.BOOL_LIST_PACKED : FieldType.BOOL_LIST;
            }
            case BYTES: {
                return fieldDescriptor.isRepeated() ? FieldType.BYTES_LIST : FieldType.BYTES;
            }
            case DOUBLE: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.DOUBLE;
                }
                return fieldDescriptor.isPacked() ? FieldType.DOUBLE_LIST_PACKED : FieldType.DOUBLE_LIST;
            }
            case ENUM: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.ENUM;
                }
                return fieldDescriptor.isPacked() ? FieldType.ENUM_LIST_PACKED : FieldType.ENUM_LIST;
            }
            case FIXED32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.FIXED32;
                }
                return fieldDescriptor.isPacked() ? FieldType.FIXED32_LIST_PACKED : FieldType.FIXED32_LIST;
            }
            case FIXED64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.FIXED64;
                }
                return fieldDescriptor.isPacked() ? FieldType.FIXED64_LIST_PACKED : FieldType.FIXED64_LIST;
            }
            case FLOAT: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.FLOAT;
                }
                return fieldDescriptor.isPacked() ? FieldType.FLOAT_LIST_PACKED : FieldType.FLOAT_LIST;
            }
            case GROUP: {
                return fieldDescriptor.isRepeated() ? FieldType.GROUP_LIST : FieldType.GROUP;
            }
            case INT32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.INT32;
                }
                return fieldDescriptor.isPacked() ? FieldType.INT32_LIST_PACKED : FieldType.INT32_LIST;
            }
            case INT64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.INT64;
                }
                return fieldDescriptor.isPacked() ? FieldType.INT64_LIST_PACKED : FieldType.INT64_LIST;
            }
            case MESSAGE: {
                if (fieldDescriptor.isMapField()) {
                    return FieldType.MAP;
                }
                return fieldDescriptor.isRepeated() ? FieldType.MESSAGE_LIST : FieldType.MESSAGE;
            }
            case SFIXED32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SFIXED32;
                }
                return fieldDescriptor.isPacked() ? FieldType.SFIXED32_LIST_PACKED : FieldType.SFIXED32_LIST;
            }
            case SFIXED64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SFIXED64;
                }
                return fieldDescriptor.isPacked() ? FieldType.SFIXED64_LIST_PACKED : FieldType.SFIXED64_LIST;
            }
            case SINT32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SINT32;
                }
                return fieldDescriptor.isPacked() ? FieldType.SINT32_LIST_PACKED : FieldType.SINT32_LIST;
            }
            case SINT64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SINT64;
                }
                return fieldDescriptor.isPacked() ? FieldType.SINT64_LIST_PACKED : FieldType.SINT64_LIST;
            }
            case STRING: {
                return fieldDescriptor.isRepeated() ? FieldType.STRING_LIST : FieldType.STRING;
            }
            case UINT32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.UINT32;
                }
                return fieldDescriptor.isPacked() ? FieldType.UINT32_LIST_PACKED : FieldType.UINT32_LIST;
            }
            case UINT64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.UINT64;
                }
                return fieldDescriptor.isPacked() ? FieldType.UINT64_LIST_PACKED : FieldType.UINT64_LIST;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fieldDescriptor.getType()));
    }

    private static Field bitField(Class<?> clazz, int n) {
        return DescriptorMessageInfoFactory.field(clazz, "bitField" + n + "_");
    }

    private static Field field(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        return DescriptorMessageInfoFactory.field(clazz, DescriptorMessageInfoFactory.getFieldName(fieldDescriptor));
    }

    private static Field cachedSizeField(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        return DescriptorMessageInfoFactory.field(clazz, DescriptorMessageInfoFactory.getCachedSizeFieldName(fieldDescriptor));
    }

    private static Field field(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to find field " + string + " in message class " + clazz.getName());
        }
    }

    static String getFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fieldDescriptor.getMessageType().getName() : fieldDescriptor.getName();
        String string2 = DescriptorMessageInfoFactory.snakeCaseToUpperCamelCase(string);
        String string3 = specialFieldNames.contains(string2) ? "__" : "_";
        return DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(string) + string3;
    }

    private static String getCachedSizeFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        return DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(fieldDescriptor.getName()) + "MemoizedSerializedSize";
    }

    private static String snakeCaseToLowerCamelCase(String string) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(string, false);
    }

    private static String snakeCaseToUpperCamelCase(String string) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(string, true);
    }

    private static String snakeCaseToCamelCase(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
        boolean bl2 = bl;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl2 = true;
                continue;
            }
            if (Character.isDigit(c)) {
                stringBuilder.append(c);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuilder.append(Character.toUpperCase(c));
                bl2 = false;
                continue;
            }
            if (i == 0) {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static Class<?> getOneofStoredTypeForMessage(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        try {
            String string = fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fieldDescriptor.getMessageType().getName() : fieldDescriptor.getName();
            Method method = clazz.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(string), new Class[0]);
            return method.getReturnType();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Class<?> getTypeForRepeatedMessageField(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        try {
            String string = fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fieldDescriptor.getMessageType().getName() : fieldDescriptor.getName();
            Method method = clazz.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(string), Integer.TYPE);
            return method.getReturnType();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String getterForField(String string) {
        String string2 = DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(string);
        StringBuilder stringBuilder = new StringBuilder("get");
        stringBuilder.append(Character.toUpperCase(string2.charAt(0)));
        stringBuilder.append(string2.substring(1, string2.length()));
        return stringBuilder.toString();
    }

    private static final class OneofState {
        private OneofInfo[] oneofs = new OneofInfo[2];

        private OneofState() {
        }

        OneofInfo getOneof(Class<?> clazz, Descriptors.OneofDescriptor oneofDescriptor) {
            OneofInfo oneofInfo;
            int n = oneofDescriptor.getIndex();
            if (n >= this.oneofs.length) {
                this.oneofs = Arrays.copyOf(this.oneofs, n * 2);
            }
            if ((oneofInfo = this.oneofs[n]) == null) {
                this.oneofs[n] = oneofInfo = OneofState.newInfo(clazz, oneofDescriptor);
            }
            return oneofInfo;
        }

        private static OneofInfo newInfo(Class<?> clazz, Descriptors.OneofDescriptor oneofDescriptor) {
            String string = DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(oneofDescriptor.getName());
            String string2 = string + "_";
            String string3 = string + "Case_";
            return new OneofInfo(oneofDescriptor.getIndex(), DescriptorMessageInfoFactory.field(clazz, string3), DescriptorMessageInfoFactory.field(clazz, string2));
        }
    }

    static class IsInitializedCheckAnalyzer {
        private final Map<Descriptors.Descriptor, Boolean> resultCache = new ConcurrentHashMap<Descriptors.Descriptor, Boolean>();
        private int index = 0;
        private final Stack<Node> stack = new Stack();
        private final Map<Descriptors.Descriptor, Node> nodeCache = new HashMap<Descriptors.Descriptor, Node>();

        IsInitializedCheckAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
            Boolean bl = this.resultCache.get(descriptor);
            if (bl != null) {
                return bl;
            }
            IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = this;
            synchronized (isInitializedCheckAnalyzer) {
                bl = this.resultCache.get(descriptor);
                if (bl != null) {
                    return bl;
                }
                return this.dfs((Descriptors.Descriptor)descriptor).component.needsIsInitializedCheck;
            }
        }

        private Node dfs(Descriptors.Descriptor descriptor) {
            Node node = new Node(descriptor, this.index++);
            this.stack.push(node);
            this.nodeCache.put(descriptor, node);
            for (Descriptors.FieldDescriptor object : descriptor.getFields()) {
                if (object.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                Node node2 = this.nodeCache.get(object.getMessageType());
                if (node2 == null) {
                    node2 = this.dfs(object.getMessageType());
                    node.lowLink = Math.min(node.lowLink, node2.lowLink);
                    continue;
                }
                if (node2.component != null) continue;
                node.lowLink = Math.min(node.lowLink, node2.lowLink);
            }
            if (node.index == node.lowLink) {
                Node node3;
                StronglyConnectedComponent stronglyConnectedComponent = new StronglyConnectedComponent();
                do {
                    node3 = this.stack.pop();
                    node3.component = stronglyConnectedComponent;
                    stronglyConnectedComponent.messages.add(node3.descriptor);
                } while (node3 != node);
                this.analyze(stronglyConnectedComponent);
            }
            return node;
        }

        private void analyze(StronglyConnectedComponent stronglyConnectedComponent) {
            boolean bl = false;
            block0: for (Descriptors.Descriptor descriptor : stronglyConnectedComponent.messages) {
                if (descriptor.isExtendable()) {
                    bl = true;
                    break;
                }
                for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                    if (fieldDescriptor.isRequired()) {
                        bl = true;
                        break block0;
                    }
                    if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                    Node node = this.nodeCache.get(fieldDescriptor.getMessageType());
                    if (node.component == stronglyConnectedComponent || !node.component.needsIsInitializedCheck) continue;
                    bl = true;
                    break block0;
                }
            }
            stronglyConnectedComponent.needsIsInitializedCheck = bl;
            for (Descriptors.Descriptor descriptor : stronglyConnectedComponent.messages) {
                this.resultCache.put(descriptor, stronglyConnectedComponent.needsIsInitializedCheck);
            }
        }

        private static class StronglyConnectedComponent {
            final List<Descriptors.Descriptor> messages = new ArrayList<Descriptors.Descriptor>();
            boolean needsIsInitializedCheck = false;

            private StronglyConnectedComponent() {
            }
        }

        private static class Node {
            final Descriptors.Descriptor descriptor;
            final int index;
            int lowLink;
            StronglyConnectedComponent component;

            Node(Descriptors.Descriptor descriptor, int n) {
                this.descriptor = descriptor;
                this.index = n;
                this.lowLink = n;
                this.component = null;
            }
        }
    }
}

