/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.BooleanArrayList;
import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.DoubleArrayList;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.google.protobuf.FloatArrayList;
import com.mathworks.google.protobuf.IntArrayList;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.InvalidProtocolBufferException;
import com.mathworks.google.protobuf.LazyStringList;
import com.mathworks.google.protobuf.LongArrayList;
import com.mathworks.google.protobuf.MapEntryLite;
import com.mathworks.google.protobuf.Protobuf;
import com.mathworks.google.protobuf.Reader;
import com.mathworks.google.protobuf.Schema;
import com.mathworks.google.protobuf.Utf8;
import com.mathworks.google.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@CheckReturnValue
abstract class BinaryReader
implements Reader {
    private static final int FIXED32_MULTIPLE_MASK = 3;
    private static final int FIXED64_MULTIPLE_MASK = 7;

    public static BinaryReader newInstance(ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer.hasArray()) {
            return new SafeHeapReader(byteBuffer, bl);
        }
        throw new IllegalArgumentException("Direct buffers not yet supported");
    }

    private BinaryReader() {
    }

    public abstract int getTotalBytesRead();

    @Override
    public boolean shouldDiscardUnknownFields() {
        return false;
    }

    private static final class SafeHeapReader
    extends BinaryReader {
        private final boolean bufferIsImmutable;
        private final byte[] buffer;
        private int pos;
        private final int initialPos;
        private int limit;
        private int tag;
        private int endGroupTag;

        public SafeHeapReader(ByteBuffer byteBuffer, boolean bl) {
            this.bufferIsImmutable = bl;
            this.buffer = byteBuffer.array();
            this.initialPos = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
            this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
        }

        private boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        public int getTotalBytesRead() {
            return this.pos - this.initialPos;
        }

        @Override
        public int getFieldNumber() throws IOException {
            if (this.isAtEnd()) {
                return Integer.MAX_VALUE;
            }
            this.tag = this.readVarint32();
            if (this.tag == this.endGroupTag) {
                return Integer.MAX_VALUE;
            }
            return WireFormat.getTagFieldNumber(this.tag);
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public boolean skipField() throws IOException {
            if (this.isAtEnd() || this.tag == this.endGroupTag) {
                return false;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    this.skipVarint();
                    return true;
                }
                case 1: {
                    this.skipBytes(8);
                    return true;
                }
                case 2: {
                    this.skipBytes(this.readVarint32());
                    return true;
                }
                case 5: {
                    this.skipBytes(4);
                    return true;
                }
                case 3: {
                    this.skipGroup();
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public double readDouble() throws IOException {
            this.requireWireType(1);
            return Double.longBitsToDouble(this.readLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            this.requireWireType(5);
            return Float.intBitsToFloat(this.readLittleEndian32());
        }

        @Override
        public long readUInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public long readInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public int readInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public int readFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public boolean readBool() throws IOException {
            this.requireWireType(0);
            return this.readVarint32() != 0;
        }

        @Override
        public String readString() throws IOException {
            return this.readStringInternal(false);
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            return this.readStringInternal(true);
        }

        public String readStringInternal(boolean bl) throws IOException {
            this.requireWireType(2);
            int n = this.readVarint32();
            if (n == 0) {
                return "";
            }
            this.requireBytes(n);
            if (bl && !Utf8.isValidUtf8(this.buffer, this.pos, this.pos + n)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
            this.pos += n;
            return string;
        }

        @Override
        public <T> T readMessage(Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(2);
            return (T)this.readMessage(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
        }

        @Override
        public <T> T readMessageBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(2);
            return this.readMessage(schema, extensionRegistryLite);
        }

        private <T> T readMessage(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            T t = schema.newInstance();
            this.mergeMessageField(t, schema, extensionRegistryLite);
            schema.makeImmutable(t);
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void mergeMessageField(T t, Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            int n2 = this.readVarint32();
            this.requireBytes(n2);
            int n3 = this.limit;
            this.limit = n = this.pos + n2;
            try {
                schema.mergeFrom(t, this, extensionRegistryLite);
                if (this.pos != n) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
            }
            finally {
                this.limit = n3;
            }
        }

        @Override
        @Deprecated
        public <T> T readGroup(Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(3);
            return (T)this.readGroup(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
        }

        @Override
        @Deprecated
        public <T> T readGroupBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(3);
            return this.readGroup(schema, extensionRegistryLite);
        }

        private <T> T readGroup(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            T t = schema.newInstance();
            this.mergeGroupField(t, schema, extensionRegistryLite);
            schema.makeImmutable(t);
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void mergeGroupField(T t, Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            try {
                schema.mergeFrom(t, this, extensionRegistryLite);
                if (this.tag != this.endGroupTag) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
            }
            finally {
                this.endGroupTag = n;
            }
        }

        @Override
        public ByteString readBytes() throws IOException {
            this.requireWireType(2);
            int n = this.readVarint32();
            if (n == 0) {
                return ByteString.EMPTY;
            }
            this.requireBytes(n);
            ByteString byteString = this.bufferIsImmutable ? ByteString.wrap(this.buffer, this.pos, n) : ByteString.copyFrom(this.buffer, this.pos, n);
            this.pos += n;
            return byteString;
        }

        @Override
        public int readUInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public int readEnum() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public int readSFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public long readSFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public int readSInt32() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag32(this.readVarint32());
        }

        @Override
        public long readSInt64() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag64(this.readVarint64());
        }

        @Override
        public void readDoubleList(List<Double> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof DoubleArrayList)) break block14;
                    DoubleArrayList doubleArrayList = (DoubleArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            this.verifyPackedFixed64Length(n);
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                doubleArrayList.addDouble(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                            }
                            break block15;
                        }
                        case 1: {
                            int n;
                            int n3;
                            do {
                                doubleArrayList.addDouble(this.readDouble());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        this.verifyPackedFixed64Length(n);
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                        }
                        break;
                    }
                    case 1: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readDouble());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readFloatList(List<Float> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof FloatArrayList)) break block14;
                    FloatArrayList floatArrayList = (FloatArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            this.verifyPackedFixed32Length(n);
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                floatArrayList.addFloat(Float.intBitsToFloat(this.readLittleEndian32_NoCheck()));
                            }
                            break block15;
                        }
                        case 5: {
                            int n;
                            int n3;
                            do {
                                floatArrayList.addFloat(this.readFloat());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        this.verifyPackedFixed32Length(n);
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(Float.valueOf(Float.intBitsToFloat(this.readLittleEndian32_NoCheck())));
                        }
                        break;
                    }
                    case 5: {
                        int n;
                        int n5;
                        do {
                            list.add(Float.valueOf(this.readFloat()));
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readUInt64List(List<Long> list) throws IOException {
            if (list instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n2 = this.pos + n;
                        while (this.pos < n2) {
                            longArrayList.addLong(this.readVarint64());
                        }
                        this.requirePosition(n2);
                        break;
                    }
                    case 0: {
                        int n;
                        int n3;
                        do {
                            longArrayList.addLong(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n3 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readVarint64());
                        }
                        this.requirePosition(n4);
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readInt64List(List<Long> list) throws IOException {
            if (list instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n2 = this.pos + n;
                        while (this.pos < n2) {
                            longArrayList.addLong(this.readVarint64());
                        }
                        this.requirePosition(n2);
                        break;
                    }
                    case 0: {
                        int n;
                        int n3;
                        do {
                            longArrayList.addLong(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n3 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readVarint64());
                        }
                        this.requirePosition(n4);
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readInt32List(List<Integer> list) throws IOException {
            if (list instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n2 = this.pos + n;
                        while (this.pos < n2) {
                            intArrayList.addInt(this.readVarint32());
                        }
                        this.requirePosition(n2);
                        break;
                    }
                    case 0: {
                        int n;
                        int n3;
                        do {
                            intArrayList.addInt(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n3 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readVarint32());
                        }
                        this.requirePosition(n4);
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readFixed64List(List<Long> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            this.verifyPackedFixed64Length(n);
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                longArrayList.addLong(this.readLittleEndian64_NoCheck());
                            }
                            break block15;
                        }
                        case 1: {
                            int n;
                            int n3;
                            do {
                                longArrayList.addLong(this.readFixed64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        this.verifyPackedFixed64Length(n);
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readFixed32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            this.verifyPackedFixed32Length(n);
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                intArrayList.addInt(this.readLittleEndian32_NoCheck());
                            }
                            break block15;
                        }
                        case 5: {
                            int n;
                            int n3;
                            do {
                                intArrayList.addInt(this.readFixed32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        this.verifyPackedFixed32Length(n);
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readBoolList(List<Boolean> list) throws IOException {
            if (list instanceof BooleanArrayList) {
                BooleanArrayList booleanArrayList = (BooleanArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n2 = this.pos + n;
                        while (this.pos < n2) {
                            booleanArrayList.addBoolean(this.readVarint32() != 0);
                        }
                        this.requirePosition(n2);
                        break;
                    }
                    case 0: {
                        int n;
                        int n3;
                        do {
                            booleanArrayList.addBoolean(this.readBool());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n3 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readVarint32() != 0);
                        }
                        this.requirePosition(n4);
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readBool());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readStringList(List<String> list) throws IOException {
            this.readStringListInternal(list, false);
        }

        @Override
        public void readStringListRequireUtf8(List<String> list) throws IOException {
            this.readStringListInternal(list, true);
        }

        public void readStringListInternal(List<String> list, boolean bl) throws IOException {
            int n;
            int n2;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            if (list instanceof LazyStringList && !bl) {
                int n3;
                int n4;
                LazyStringList lazyStringList = (LazyStringList)list;
                do {
                    lazyStringList.add(this.readBytes());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n3 = this.pos;
                } while ((n4 = this.readVarint32()) == this.tag);
                this.pos = n3;
                return;
            }
            do {
                list.add(this.readStringInternal(bl));
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while ((n2 = this.readVarint32()) == this.tag);
            this.pos = n;
        }

        @Override
        public <T> void readMessageList(List<T> list, Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(clazz);
            this.readMessageList(list, schema, extensionRegistryLite);
        }

        @Override
        public <T> void readMessageList(List<T> list, Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            int n2;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n3 = this.tag;
            do {
                list.add(this.readMessage(schema, extensionRegistryLite));
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while ((n2 = this.readVarint32()) == n3);
            this.pos = n;
        }

        @Override
        @Deprecated
        public <T> void readGroupList(List<T> list, Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(clazz);
            this.readGroupList(list, schema, extensionRegistryLite);
        }

        @Override
        @Deprecated
        public <T> void readGroupList(List<T> list, Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            int n2;
            if (WireFormat.getTagWireType(this.tag) != 3) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n3 = this.tag;
            do {
                list.add(this.readGroup(schema, extensionRegistryLite));
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while ((n2 = this.readVarint32()) == n3);
            this.pos = n;
        }

        @Override
        public void readBytesList(List<ByteString> list) throws IOException {
            int n;
            int n2;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            do {
                list.add(this.readBytes());
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while ((n2 = this.readVarint32()) == this.tag);
            this.pos = n;
        }

        @Override
        public void readUInt32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                intArrayList.addInt(this.readVarint32());
                            }
                            break block15;
                        }
                        case 0: {
                            int n;
                            int n3;
                            do {
                                intArrayList.addInt(this.readUInt32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readUInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readEnumList(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                intArrayList.addInt(this.readVarint32());
                            }
                            break block15;
                        }
                        case 0: {
                            int n;
                            int n3;
                            do {
                                intArrayList.addInt(this.readEnum());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readEnum());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSFixed32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            this.verifyPackedFixed32Length(n);
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                intArrayList.addInt(this.readLittleEndian32_NoCheck());
                            }
                            break block15;
                        }
                        case 5: {
                            int n;
                            int n3;
                            do {
                                intArrayList.addInt(this.readSFixed32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        this.verifyPackedFixed32Length(n);
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readSFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSFixed64List(List<Long> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            this.verifyPackedFixed64Length(n);
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                longArrayList.addLong(this.readLittleEndian64_NoCheck());
                            }
                            break block15;
                        }
                        case 1: {
                            int n;
                            int n3;
                            do {
                                longArrayList.addLong(this.readSFixed64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        this.verifyPackedFixed64Length(n);
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readSFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSInt32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                intArrayList.addInt(CodedInputStream.decodeZigZag32(this.readVarint32()));
                            }
                            break block15;
                        }
                        case 0: {
                            int n;
                            int n3;
                            do {
                                intArrayList.addInt(this.readSInt32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(CodedInputStream.decodeZigZag32(this.readVarint32()));
                        }
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readSInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSInt64List(List<Long> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n = this.readVarint32();
                            int n2 = this.pos + n;
                            while (this.pos < n2) {
                                longArrayList.addLong(CodedInputStream.decodeZigZag64(this.readVarint64()));
                            }
                            break block15;
                        }
                        case 0: {
                            int n;
                            int n3;
                            do {
                                longArrayList.addLong(this.readSInt64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n = this.pos;
                            } while ((n3 = this.readVarint32()) == this.tag);
                            this.pos = n;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n = this.readVarint32();
                        int n4 = this.pos + n;
                        while (this.pos < n4) {
                            list.add(CodedInputStream.decodeZigZag64(this.readVarint64()));
                        }
                        break;
                    }
                    case 0: {
                        int n;
                        int n5;
                        do {
                            list.add(this.readSInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> void readMap(Map<K, V> map, MapEntryLite.Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            this.requireWireType(2);
            int n2 = this.readVarint32();
            this.requireBytes(n2);
            int n3 = this.limit;
            this.limit = n = this.pos + n2;
            try {
                int n4;
                Object object = metadata.defaultKey;
                Object object2 = metadata.defaultValue;
                block9: while ((n4 = this.getFieldNumber()) != Integer.MAX_VALUE) {
                    try {
                        switch (n4) {
                            case 1: {
                                object = this.readField(metadata.keyType, null, null);
                                break;
                            }
                            case 2: {
                                object2 = this.readField(metadata.valueType, metadata.defaultValue.getClass(), extensionRegistryLite);
                                break;
                            }
                            default: {
                                if (this.skipField()) continue block9;
                                throw new InvalidProtocolBufferException("Unable to parse map entry.");
                            }
                        }
                    }
                    catch (InvalidProtocolBufferException.InvalidWireTypeException invalidWireTypeException) {
                        if (this.skipField()) continue;
                        throw new InvalidProtocolBufferException("Unable to parse map entry.");
                    }
                }
                map.put(object, object2);
            }
            finally {
                this.limit = n3;
            }
        }

        private Object readField(WireFormat.FieldType fieldType, Class<?> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            switch (fieldType) {
                case BOOL: {
                    return this.readBool();
                }
                case BYTES: {
                    return this.readBytes();
                }
                case DOUBLE: {
                    return this.readDouble();
                }
                case ENUM: {
                    return this.readEnum();
                }
                case FIXED32: {
                    return this.readFixed32();
                }
                case FIXED64: {
                    return this.readFixed64();
                }
                case FLOAT: {
                    return Float.valueOf(this.readFloat());
                }
                case INT32: {
                    return this.readInt32();
                }
                case INT64: {
                    return this.readInt64();
                }
                case MESSAGE: {
                    return this.readMessage(clazz, extensionRegistryLite);
                }
                case SFIXED32: {
                    return this.readSFixed32();
                }
                case SFIXED64: {
                    return this.readSFixed64();
                }
                case SINT32: {
                    return this.readSInt32();
                }
                case SINT64: {
                    return this.readSInt64();
                }
                case STRING: {
                    return this.readStringRequireUtf8();
                }
                case UINT32: {
                    return this.readUInt32();
                }
                case UINT64: {
                    return this.readUInt64();
                }
            }
            throw new RuntimeException("unsupported field type.");
        }

        private int readVarint32() throws IOException {
            int n;
            int n2 = this.pos;
            if (this.limit == this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n = this.buffer[n2++]) >= 0) {
                this.pos = n2;
                return n;
            }
            if (this.limit - n2 < 9) {
                return (int)this.readVarint64SlowPath();
            }
            if ((n ^= this.buffer[n2++] << 7) < 0) {
                n ^= 0xFFFFFF80;
            } else if ((n ^= this.buffer[n2++] << 14) >= 0) {
                n ^= 0x3F80;
            } else if ((n ^= this.buffer[n2++] << 21) < 0) {
                n ^= 0xFFE03F80;
            } else {
                byte by = this.buffer[n2++];
                n ^= by << 28;
                n ^= 0xFE03F80;
                if (by < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = n2;
            return n;
        }

        public long readVarint64() throws IOException {
            long l;
            int n;
            int n2 = this.pos;
            if (this.limit == n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            if ((n = byArray[n2++]) >= 0) {
                this.pos = n2;
                return n;
            }
            if (this.limit - n2 < 9) {
                return this.readVarint64SlowPath();
            }
            if ((n ^= byArray[n2++] << 7) < 0) {
                l = n ^ 0xFFFFFF80;
            } else if ((n ^= byArray[n2++] << 14) >= 0) {
                l = n ^ 0x3F80;
            } else if ((n ^= byArray[n2++] << 21) < 0) {
                l = n ^ 0xFFE03F80;
            } else if ((l = (long)n ^ (long)byArray[n2++] << 28) >= 0L) {
                l ^= 0xFE03F80L;
            } else if ((l ^= (long)byArray[n2++] << 35) < 0L) {
                l ^= 0xFFFFFFF80FE03F80L;
            } else if ((l ^= (long)byArray[n2++] << 42) >= 0L) {
                l ^= 0x3F80FE03F80L;
            } else if ((l ^= (long)byArray[n2++] << 49) < 0L) {
                l ^= 0xFFFE03F80FE03F80L;
            } else {
                l ^= (long)byArray[n2++] << 56;
                if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = n2;
            return l;
        }

        private long readVarint64SlowPath() throws IOException {
            long l = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte by = this.readByte();
                l |= (long)(by & 0x7F) << i;
                if ((by & 0x80) != 0) continue;
                return l;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private byte readByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        private int readLittleEndian32() throws IOException {
            this.requireBytes(4);
            return this.readLittleEndian32_NoCheck();
        }

        private long readLittleEndian64() throws IOException {
            this.requireBytes(8);
            return this.readLittleEndian64_NoCheck();
        }

        private int readLittleEndian32_NoCheck() {
            int n = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n + 4;
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        private long readLittleEndian64_NoCheck() {
            int n = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n + 8;
            return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        private void skipVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                byte[] byArray = this.buffer;
                int n = this.pos;
                for (int i = 0; i < 10; ++i) {
                    if (byArray[n++] < 0) continue;
                    this.pos = n;
                    return;
                }
            }
            this.skipVarintSlowPath();
        }

        private void skipVarintSlowPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipBytes(int n) throws IOException {
            this.requireBytes(n);
            this.pos += n;
        }

        private void skipGroup() throws IOException {
            int n = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            while (this.getFieldNumber() != Integer.MAX_VALUE && this.skipField()) {
            }
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.endGroupTag = n;
        }

        private void requireBytes(int n) throws IOException {
            if (n < 0 || n > this.limit - this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private void requireWireType(int n) throws IOException {
            if (WireFormat.getTagWireType(this.tag) != n) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        private void verifyPackedFixed64Length(int n) throws IOException {
            this.requireBytes(n);
            if ((n & 7) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void verifyPackedFixed32Length(int n) throws IOException {
            this.requireBytes(n);
            if ((n & 3) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void requirePosition(int n) throws IOException {
            if (this.pos != n) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }
    }
}

