/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.Internal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

abstract class AbstractProtobufList<E>
extends AbstractList<E>
implements Internal.ProtobufList<E> {
    protected static final int DEFAULT_CAPACITY = 10;
    private boolean isMutable;

    AbstractProtobufList() {
        this(true);
    }

    AbstractProtobufList(boolean bl) {
        this.isMutable = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        if (!(object instanceof RandomAccess)) {
            return super.equals(object);
        }
        List list = (List)object;
        int n = this.size();
        if (n != list.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.get(i).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.size();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + this.get(i).hashCode();
        }
        return n2;
    }

    @Override
    public boolean add(E e) {
        this.ensureIsMutable();
        return super.add(e);
    }

    @Override
    public void add(int n, E e) {
        this.ensureIsMutable();
        super.add(n, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.ensureIsMutable();
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.ensureIsMutable();
        return super.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        super.clear();
    }

    @Override
    public boolean isModifiable() {
        return this.isMutable;
    }

    @Override
    public final void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    @Override
    public E remove(int n) {
        this.ensureIsMutable();
        return super.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.ensureIsMutable();
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.ensureIsMutable();
        return super.retainAll(collection);
    }

    @Override
    public E set(int n, E e) {
        this.ensureIsMutable();
        return super.set(n, e);
    }

    protected void ensureIsMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }
}

