/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.client;

import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.StatusLine;
import com.mathworks.apache.http.annotation.Contract;
import com.mathworks.apache.http.annotation.ThreadingBehavior;
import com.mathworks.apache.http.client.HttpResponseException;
import com.mathworks.apache.http.client.ResponseHandler;
import com.mathworks.apache.http.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

