/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.client.utils.URIBuilder;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWInvokeRequest;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.internal.ApacheFevalHandler;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.internal.ResponseProducer;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.net.URL;
import org.slf4j.Logger;

public class ComponentProxy
implements MWInvokable {
    private final MWFevalHandler fevalHandler;
    private final URL componentURL;
    private final MWAttributesContainer attributesContainer;
    private final MWHttpClient mwClient;
    private final MWClientUsageLock mwClientUsageLock;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public ComponentProxy(MWFevalHandler mWFevalHandler, URL uRL, MWMarshalingRules mWMarshalingRules, MWClientUsageLock mWClientUsageLock, MWHttpClient mWHttpClient) {
        this.fevalHandler = mWFevalHandler;
        this.componentURL = uRL;
        this.attributesContainer = new MWAttributesContainer(mWMarshalingRules);
        this.mwClient = mWHttpClient;
        this.mwClientUsageLock = mWClientUsageLock;
        this.LOG.debug("Component proxy initialized for component: {}", (Object)this.componentURL);
    }

    @Override
    public <T> T invoke(String string, int n, Class<T> clazz, Object ... objectArray) throws Throwable {
        return this.processRequest(string, n, clazz, true, objectArray);
    }

    @Override
    public <T> T invoke(String string, Class<T> clazz, Object ... objectArray) throws Throwable {
        return this.processRequest(string, 1, clazz, false, objectArray);
    }

    @Override
    public void invokeVoid(String string, Object ... objectArray) throws Throwable {
        this.processRequest(string, 0, Void.TYPE, false, objectArray);
    }

    @Override
    public <T> MWRequest<T> invokeAsync(MWInvokeRequest<T> mWInvokeRequest, MWRequestListener<T> mWRequestListener) {
        if (!this.mwClient.getConfig().isInterruptible()) {
            throw new RuntimeException("A non-interruptible client cannot be used to invoke methods asynchronously");
        }
        boolean bl = false;
        int n = mWInvokeRequest.getNargout();
        String string = mWInvokeRequest.getMLFunction();
        Class<T> clazz = mWInvokeRequest.getTargetType();
        Object[] objectArray = mWInvokeRequest.getInputParams();
        if (n > 1) {
            bl = true;
        }
        return this.processRequestAsync(string, n, clazz, mWRequestListener, bl, objectArray);
    }

    private <T> T processRequest(String string, int n, Class<T> clazz, boolean bl, Object ... objectArray) throws Throwable {
        this.mwClientUsageLock.usageEnter("MWHttpClient that provided the proxy object has already been closed");
        this.LOG.info("Invoking function (sync): {}", (Object)string);
        try {
            if (n > 1 && clazz != Object[].class) {
                throw new IllegalArgumentException("targetType must be Object[] if nargout value is greater than 1");
            }
            MATLABParams.MATLAB_Params mATLAB_Params = MWInvocationHandlerUtils.createMATLABParams(n, objectArray, this.attributesContainer);
            MATLABResult.MATLAB_Result mATLAB_Result = this.fevalHandler.processRequest(new URL(this.componentURL.toString() + "/" + string), mATLAB_Params);
            ResponseProducer<T> responseProducer = new ResponseProducer<T>(n, clazz, this.attributesContainer, string, bl);
            responseProducer.checkMLResultForErrors(mATLAB_Result);
            Object object = responseProducer.createMATLABResponse(mATLAB_Result);
            return (T)object;
        }
        finally {
            this.mwClientUsageLock.usageExit();
        }
    }

    private <T> MWRequest<T> processRequestAsync(String string, int n, Class<T> clazz, MWRequestListener<T> mWRequestListener, boolean bl, Object ... objectArray) {
        this.mwClientUsageLock.usageEnter("MWHttpClient that provided the proxy object has already been closed");
        try {
            if (n > 1 && clazz != Object[].class) {
                throw new IllegalArgumentException("targetType must be Object[] if nargout value is greater than 1");
            }
            if (n == 0 && clazz != Void.TYPE && clazz != Void.class) {
                throw new IllegalArgumentException("targetType must be void if nargout value is equal to 0");
            }
            if ((clazz == Void.TYPE || clazz == Void.class) && n != 0) {
                throw new IllegalArgumentException("targetType must be void if nargout value is equal to 0");
            }
            URIBuilder uRIBuilder = new URIBuilder(this.componentURL.toString() + "/" + string);
            uRIBuilder.addParameter("mode", "async");
            uRIBuilder.addParameter("client", this.mwClient.getClientUUID().toString());
            MATLABParams.MATLAB_Params mATLAB_Params = MWInvocationHandlerUtils.createMATLABParams(n, objectArray, this.attributesContainer);
            ResponseProducer<T> responseProducer = new ResponseProducer<T>(n, clazz, this.attributesContainer, string, bl);
            return this.fevalHandler.processRequest(new URL(uRIBuilder.toString()), mATLAB_Params, responseProducer, mWRequestListener);
        }
        catch (Exception exception) {
            this.mwClientUsageLock.usageExit();
            MWRequestImpl mWRequestImpl = new MWRequestImpl(this.mwClient, mWRequestListener, null, (ApacheFevalHandler)this.fevalHandler);
            mWRequestImpl.updateStateAndNotify(new FailedMWRequestState(exception));
            return mWRequestImpl;
        }
    }
}

