/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import com.mathworks.mps.client.MWHttpClient;
import java.io.IOException;
import org.slf4j.Logger;

public class MWHttpException
extends IOException {
    private final int responseCode;
    private final String responseMessage;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MWHttpException(int n, String string) {
        if (n < 400) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid HTTP response code");
            this.LOG.error("{}", illegalArgumentException);
            throw illegalArgumentException;
        }
        if (string.length() == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid HTTP response message");
            this.LOG.error("{}", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.responseCode = n;
        this.responseMessage = string;
        this.LOG.error("MWHttpException - error code: {} - message: {}", (Object)n, (Object)string);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String getMessage() {
        return "Failed HTTP request; Response Status: " + this.responseCode + ", Response Message: " + this.responseMessage;
    }
}

