/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class MWCustomSSLContext
extends SSLContext {
    private static final String[] tlsProtocols;
    private final String[] enabledProtocols;

    public static SSLContext getInstance(String string) throws NoSuchAlgorithmException {
        return MWCustomSSLContext.getInstance(new String[]{string});
    }

    public static SSLContext getInstance(String string, String string2) throws NoSuchAlgorithmException {
        return MWCustomSSLContext.getInstance(new String[]{string, string2});
    }

    public static SSLContext getInstance(String ... stringArray) throws NoSuchAlgorithmException {
        if (stringArray.length == 0) {
            stringArray = tlsProtocols;
        }
        String string = stringArray[0];
        return new MWCustomSSLContext(new MWCustomSSLContextSpi(SSLContext.getInstance(string), stringArray), stringArray);
    }

    private MWCustomSSLContext(MWCustomSSLContextSpi mWCustomSSLContextSpi, String[] stringArray) {
        super(mWCustomSSLContextSpi, mWCustomSSLContextSpi.getProvider(), mWCustomSSLContextSpi.getProtocol());
        this.enabledProtocols = stringArray;
    }

    static {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            sSLContext.init(null, null, null);
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : sSLEngine.getSupportedProtocols()) {
                boolean bl = string.toLowerCase().contains("ssl");
                if (bl) continue;
                arrayList.add(string);
            }
            String[] stringArray = new String[arrayList.size()];
            tlsProtocols = arrayList.toArray(stringArray);
        }
        catch (KeyManagementException keyManagementException) {
            Throwable throwable = keyManagementException.getCause();
            throw (RuntimeException)throwable;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Throwable throwable = noSuchAlgorithmException.getCause();
            throw (RuntimeException)throwable;
        }
    }

    private static final class MWCustomSSLContextSpi
    extends SSLContextSpi {
        private final SSLContext fSSLContext;
        private SSLSocketFactory fSSLSocketFactory = null;
        private SSLServerSocketFactory fSSLServerSocketFactory = null;
        private final String[] enabledProtocols;

        MWCustomSSLContextSpi(SSLContext sSLContext, String[] stringArray) {
            this.fSSLContext = sSLContext;
            this.enabledProtocols = stringArray;
        }

        @Override
        public SSLEngine engineCreateSSLEngine() {
            SSLEngine sSLEngine = this.fSSLContext.createSSLEngine();
            sSLEngine.setEnabledProtocols(this.enabledProtocols);
            return sSLEngine;
        }

        @Override
        public SSLEngine engineCreateSSLEngine(String string, int n) {
            SSLEngine sSLEngine = this.fSSLContext.createSSLEngine(string, n);
            sSLEngine.setEnabledProtocols(this.enabledProtocols);
            return sSLEngine;
        }

        @Override
        public SSLSessionContext engineGetClientSessionContext() {
            return this.fSSLContext.getClientSessionContext();
        }

        @Override
        public SSLParameters engineGetDefaultSSLParameters() {
            return this.fSSLContext.getDefaultSSLParameters();
        }

        @Override
        public SSLSessionContext engineGetServerSessionContext() {
            return this.fSSLContext.getServerSessionContext();
        }

        @Override
        public synchronized SSLServerSocketFactory engineGetServerSocketFactory() {
            if (this.fSSLServerSocketFactory == null) {
                this.fSSLServerSocketFactory = new MWCustomSSLServerSocketFactory(this.fSSLContext);
            }
            return this.fSSLServerSocketFactory;
        }

        @Override
        public synchronized SSLSocketFactory engineGetSocketFactory() {
            if (this.fSSLSocketFactory == null) {
                this.fSSLSocketFactory = new MWCustomSSLSocketFactory(this.fSSLContext, this.enabledProtocols);
            }
            return this.fSSLSocketFactory;
        }

        @Override
        public SSLParameters engineGetSupportedSSLParameters() {
            return this.fSSLContext.getSupportedSSLParameters();
        }

        @Override
        public synchronized void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
            this.fSSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
        }

        private Provider getProvider() {
            return this.fSSLContext.getProvider();
        }

        private String getProtocol() {
            return this.fSSLContext.getProtocol();
        }

        private final class MWCustomSSLServerSocketFactory
        extends SSLServerSocketFactory {
            private final SSLServerSocketFactory fSSLServerSocketFactory;

            MWCustomSSLServerSocketFactory(SSLContext sSLContext) {
                this.fSSLServerSocketFactory = sSLContext.getServerSocketFactory();
            }

            @Override
            public ServerSocket createServerSocket() throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket());
            }

            @Override
            public ServerSocket createServerSocket(int n) throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket(n));
            }

            @Override
            public ServerSocket createServerSocket(int n, int n2) throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket(n, n2));
            }

            @Override
            public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket(n, n2, inetAddress));
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.fSSLServerSocketFactory.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.fSSLServerSocketFactory.getSupportedCipherSuites();
            }

            private SSLServerSocket restrictProtocols(ServerSocket serverSocket) {
                assert (serverSocket instanceof SSLServerSocket) : "An SSLServerSocketFactory has made a ServerSocket that is not an SSLServerSocket";
                SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
                sSLServerSocket.setEnabledProtocols(MWCustomSSLContextSpi.this.enabledProtocols);
                return sSLServerSocket;
            }
        }

        private final class MWCustomSSLSocketFactory
        extends SSLSocketFactory {
            private final SSLSocketFactory fCustomSSLSocketFactory;
            private final String[] enabledProtocols;

            MWCustomSSLSocketFactory(SSLContext sSLContext, String[] stringArray) {
                this.fCustomSSLSocketFactory = sSLContext.getSocketFactory();
                this.enabledProtocols = stringArray;
            }

            @Override
            public Socket createSocket() throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket());
            }

            @Override
            public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(socket, string, n, bl));
            }

            @Override
            public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(inetAddress, n));
            }

            @Override
            public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(inetAddress, n, inetAddress2, n2));
            }

            @Override
            public Socket createSocket(String string, int n) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(string, n));
            }

            @Override
            public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(string, n, inetAddress, n2));
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.fCustomSSLSocketFactory.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.fCustomSSLSocketFactory.getSupportedCipherSuites();
            }

            private SSLSocket restrictProtocols(Socket socket) {
                assert (socket instanceof SSLSocket) : "An SSLSocketFactory has made a Socket that is not an SSLSocket";
                SSLSocket sSLSocket = (SSLSocket)socket;
                sSLSocket.setEnabledProtocols(this.enabledProtocols);
                return sSLSocket;
            }
        }
    }
}

