/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.LazyStringArrayList;
import com.mathworks.google.protobuf.LazyStringList;
import com.mathworks.google.protobuf.PrimitiveNonBoxingCollection;
import com.mathworks.google.protobuf.UnmodifiableLazyStringList;
import com.mathworks.google.protobuf.UnsafeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@CheckReturnValue
abstract class ListFieldSchema {
    private static final ListFieldSchema FULL_INSTANCE = new ListFieldSchemaFull();
    private static final ListFieldSchema LITE_INSTANCE = new ListFieldSchemaLite();

    private ListFieldSchema() {
    }

    abstract <L> List<L> mutableListAt(Object var1, long var2);

    abstract void makeImmutableListAt(Object var1, long var2);

    abstract <L> void mergeListsAt(Object var1, Object var2, long var3);

    static ListFieldSchema full() {
        return FULL_INSTANCE;
    }

    static ListFieldSchema lite() {
        return LITE_INSTANCE;
    }

    private static final class ListFieldSchemaLite
    extends ListFieldSchema {
        private ListFieldSchemaLite() {
        }

        @Override
        <L> List<L> mutableListAt(Object object, long l) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(object, l);
            if (!protobufList.isModifiable()) {
                int n = protobufList.size();
                protobufList = protobufList.mutableCopyWithCapacity(n == 0 ? 10 : n * 2);
                UnsafeUtil.putObject(object, l, protobufList);
            }
            return protobufList;
        }

        @Override
        void makeImmutableListAt(Object object, long l) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(object, l);
            protobufList.makeImmutable();
        }

        @Override
        <E> void mergeListsAt(Object object, Object object2, long l) {
            Internal.ProtobufList<E> protobufList = ListFieldSchemaLite.getProtobufList(object, l);
            Internal.ProtobufList<E> protobufList2 = ListFieldSchemaLite.getProtobufList(object2, l);
            int n = protobufList.size();
            int n2 = protobufList2.size();
            if (n > 0 && n2 > 0) {
                if (!protobufList.isModifiable()) {
                    protobufList = protobufList.mutableCopyWithCapacity(n + n2);
                }
                protobufList.addAll(protobufList2);
            }
            Internal.ProtobufList<E> protobufList3 = n > 0 ? protobufList : protobufList2;
            UnsafeUtil.putObject(object, l, protobufList3);
        }

        static <E> Internal.ProtobufList<E> getProtobufList(Object object, long l) {
            return (Internal.ProtobufList)UnsafeUtil.getObject(object, l);
        }
    }

    private static final class ListFieldSchemaFull
    extends ListFieldSchema {
        private static final Class<?> UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();

        private ListFieldSchemaFull() {
        }

        @Override
        <L> List<L> mutableListAt(Object object, long l) {
            return ListFieldSchemaFull.mutableListAt(object, l, 10);
        }

        @Override
        void makeImmutableListAt(Object object, long l) {
            List list = (List)UnsafeUtil.getObject(object, l);
            List<String> list2 = null;
            if (list instanceof LazyStringList) {
                list2 = ((LazyStringList)list).getUnmodifiableView();
            } else {
                if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                    return;
                }
                if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList) {
                    if (((Internal.ProtobufList)list).isModifiable()) {
                        ((Internal.ProtobufList)list).makeImmutable();
                    }
                    return;
                }
                list2 = Collections.unmodifiableList(list);
            }
            UnsafeUtil.putObject(object, l, (Object)list2);
        }

        private static <L> List<L> mutableListAt(Object object, long l, int n) {
            List<String> list = ListFieldSchemaFull.getList(object, l);
            if (list.isEmpty()) {
                list = list instanceof LazyStringList ? new LazyStringArrayList(n) : (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList ? ((Internal.ProtobufList)list).mutableCopyWithCapacity(n) : new ArrayList(n));
                UnsafeUtil.putObject(object, l, (Object)list);
            } else if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size() + n);
                arrayList.addAll(list);
                list = arrayList;
                UnsafeUtil.putObject(object, l, list);
            } else if (list instanceof UnmodifiableLazyStringList) {
                LazyStringArrayList lazyStringArrayList = new LazyStringArrayList(list.size() + n);
                lazyStringArrayList.addAll((UnmodifiableLazyStringList)list);
                list = lazyStringArrayList;
                UnsafeUtil.putObject(object, l, list);
            } else if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList && !((Internal.ProtobufList)list).isModifiable()) {
                list = ((Internal.ProtobufList)list).mutableCopyWithCapacity(list.size() + n);
                UnsafeUtil.putObject(object, l, list);
            }
            return list;
        }

        @Override
        <E> void mergeListsAt(Object object, Object object2, long l) {
            List<E> list = ListFieldSchemaFull.getList(object2, l);
            List list2 = ListFieldSchemaFull.mutableListAt(object, l, list.size());
            int n = list2.size();
            int n2 = list.size();
            if (n > 0 && n2 > 0) {
                list2.addAll(list);
            }
            List<Object> list3 = n > 0 ? list2 : list;
            UnsafeUtil.putObject(object, l, list3);
        }

        static <E> List<E> getList(Object object, long l) {
            return (List)UnsafeUtil.getObject(object, l);
        }
    }
}

