/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.BooleanArrayList;
import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.DoubleArrayList;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.google.protobuf.FieldSet;
import com.mathworks.google.protobuf.FloatArrayList;
import com.mathworks.google.protobuf.GeneratedMessageLite;
import com.mathworks.google.protobuf.IntArrayList;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.InvalidProtocolBufferException;
import com.mathworks.google.protobuf.LongArrayList;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.MessageSchema;
import com.mathworks.google.protobuf.Protobuf;
import com.mathworks.google.protobuf.Schema;
import com.mathworks.google.protobuf.SchemaUtil;
import com.mathworks.google.protobuf.UnknownFieldSchema;
import com.mathworks.google.protobuf.UnknownFieldSetLite;
import com.mathworks.google.protobuf.Utf8;
import com.mathworks.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;

@CheckReturnValue
final class ArrayDecoders {
    private ArrayDecoders() {
    }

    static int decodeVarint32(byte[] byArray, int n, Registers registers) {
        int n2;
        if ((n2 = byArray[n++]) >= 0) {
            registers.int1 = n2;
            return n;
        }
        return ArrayDecoders.decodeVarint32(n2, byArray, n, registers);
    }

    static int decodeVarint32(int n, byte[] byArray, int n2, Registers registers) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n3 = n & 0x7F;
        if ((by4 = byArray[n2++]) >= 0) {
            registers.int1 = n3 | by4 << 7;
            return n2;
        }
        n3 |= (by4 & 0x7F) << 7;
        if ((by3 = byArray[n2++]) >= 0) {
            registers.int1 = n3 | by3 << 14;
            return n2;
        }
        n3 |= (by3 & 0x7F) << 14;
        if ((by2 = byArray[n2++]) >= 0) {
            registers.int1 = n3 | by2 << 21;
            return n2;
        }
        n3 |= (by2 & 0x7F) << 21;
        if ((by = byArray[n2++]) >= 0) {
            registers.int1 = n3 | by << 28;
            return n2;
        }
        n3 |= (by & 0x7F) << 28;
        while (byArray[n2++] < 0) {
        }
        registers.int1 = n3;
        return n2;
    }

    static int decodeVarint64(byte[] byArray, int n, Registers registers) {
        long l;
        if ((l = (long)byArray[n++]) >= 0L) {
            registers.long1 = l;
            return n;
        }
        return ArrayDecoders.decodeVarint64(l, byArray, n, registers);
    }

    static int decodeVarint64(long l, byte[] byArray, int n, Registers registers) {
        long l2 = l & 0x7FL;
        byte by = byArray[n++];
        int n2 = 7;
        l2 |= (long)(by & 0x7F) << 7;
        while (by < 0) {
            by = byArray[n++];
            l2 |= (long)(by & 0x7F) << (n2 += 7);
        }
        registers.long1 = l2;
        return n;
    }

    static int decodeFixed32(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static long decodeFixed64(byte[] byArray, int n) {
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    static double decodeDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(ArrayDecoders.decodeFixed64(byArray, n));
    }

    static float decodeFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(ArrayDecoders.decodeFixed32(byArray, n));
    }

    static int decodeString(byte[] byArray, int n, Registers registers) throws InvalidProtocolBufferException {
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 == 0) {
            registers.object1 = "";
            return n;
        }
        registers.object1 = new String(byArray, n, n2, Internal.UTF_8);
        return n + n2;
    }

    static int decodeStringRequireUtf8(byte[] byArray, int n, Registers registers) throws InvalidProtocolBufferException {
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 == 0) {
            registers.object1 = "";
            return n;
        }
        registers.object1 = Utf8.decodeUtf8(byArray, n, n2);
        return n + n2;
    }

    static int decodeBytes(byte[] byArray, int n, Registers registers) throws InvalidProtocolBufferException {
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 > byArray.length - n) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n2 == 0) {
            registers.object1 = ByteString.EMPTY;
            return n;
        }
        registers.object1 = ByteString.copyFrom(byArray, n, n2);
        return n + n2;
    }

    static int decodeMessageField(Schema schema, byte[] byArray, int n, int n2, Registers registers) throws IOException {
        Object t = schema.newInstance();
        int n3 = ArrayDecoders.mergeMessageField(t, schema, byArray, n, n2, registers);
        schema.makeImmutable(t);
        registers.object1 = t;
        return n3;
    }

    static int decodeGroupField(Schema schema, byte[] byArray, int n, int n2, int n3, Registers registers) throws IOException {
        Object t = schema.newInstance();
        int n4 = ArrayDecoders.mergeGroupField(t, schema, byArray, n, n2, n3, registers);
        schema.makeImmutable(t);
        registers.object1 = t;
        return n4;
    }

    static int mergeMessageField(Object object, Schema schema, byte[] byArray, int n, int n2, Registers registers) throws IOException {
        int n3;
        if ((n3 = byArray[n++]) < 0) {
            n = ArrayDecoders.decodeVarint32(n3, byArray, n, registers);
            n3 = registers.int1;
        }
        if (n3 < 0 || n3 > n2 - n) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        schema.mergeFrom(object, byArray, n, n + n3, registers);
        registers.object1 = object;
        return n + n3;
    }

    static int mergeGroupField(Object object, Schema schema, byte[] byArray, int n, int n2, int n3, Registers registers) throws IOException {
        MessageSchema messageSchema = (MessageSchema)schema;
        int n4 = messageSchema.parseMessage(object, byArray, n, n2, n3, registers);
        registers.object1 = object;
        return n4;
    }

    static int decodeVarint32List(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        intArrayList.addInt(registers.int1);
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint32(byArray, n4, registers);
            intArrayList.addInt(registers.int1);
        }
        return n2;
    }

    static int decodeVarint64List(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
        longArrayList.addLong(registers.long1);
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint64(byArray, n4, registers);
            longArrayList.addLong(registers.long1);
        }
        return n2;
    }

    static int decodeFixed32List(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        intArrayList.addInt(ArrayDecoders.decodeFixed32(byArray, n2));
        n2 += 4;
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            intArrayList.addInt(ArrayDecoders.decodeFixed32(byArray, n4));
            n2 = n4 + 4;
        }
        return n2;
    }

    static int decodeFixed64List(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        longArrayList.addLong(ArrayDecoders.decodeFixed64(byArray, n2));
        n2 += 8;
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            longArrayList.addLong(ArrayDecoders.decodeFixed64(byArray, n4));
            n2 = n4 + 8;
        }
        return n2;
    }

    static int decodeFloatList(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        FloatArrayList floatArrayList = (FloatArrayList)protobufList;
        floatArrayList.addFloat(ArrayDecoders.decodeFloat(byArray, n2));
        n2 += 4;
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            floatArrayList.addFloat(ArrayDecoders.decodeFloat(byArray, n4));
            n2 = n4 + 4;
        }
        return n2;
    }

    static int decodeDoubleList(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)protobufList;
        doubleArrayList.addDouble(ArrayDecoders.decodeDouble(byArray, n2));
        n2 += 8;
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            doubleArrayList.addDouble(ArrayDecoders.decodeDouble(byArray, n4));
            n2 = n4 + 8;
        }
        return n2;
    }

    static int decodeBoolList(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        BooleanArrayList booleanArrayList = (BooleanArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
        booleanArrayList.addBoolean(registers.long1 != 0L);
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint64(byArray, n4, registers);
            booleanArrayList.addBoolean(registers.long1 != 0L);
        }
        return n2;
    }

    static int decodeSInt32List(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint32(byArray, n4, registers);
            intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        return n2;
    }

    static int decodeSInt64List(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
        longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint64(byArray, n4, registers);
            longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        return n2;
    }

    static int decodePackedVarint32List(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = n + registers.int1;
        while (n < n2) {
            n = ArrayDecoders.decodeVarint32(byArray, n, registers);
            intArrayList.addInt(registers.int1);
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedVarint64List(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = n + registers.int1;
        while (n < n2) {
            n = ArrayDecoders.decodeVarint64(byArray, n, registers);
            longArrayList.addLong(registers.long1);
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedFixed32List(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        int n2 = n + registers.int1;
        for (n = ArrayDecoders.decodeVarint32(byArray, n, registers); n < n2; n += 4) {
            intArrayList.addInt(ArrayDecoders.decodeFixed32(byArray, n));
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedFixed64List(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        int n2 = n + registers.int1;
        for (n = ArrayDecoders.decodeVarint32(byArray, n, registers); n < n2; n += 8) {
            longArrayList.addLong(ArrayDecoders.decodeFixed64(byArray, n));
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedFloatList(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        FloatArrayList floatArrayList = (FloatArrayList)protobufList;
        int n2 = n + registers.int1;
        for (n = ArrayDecoders.decodeVarint32(byArray, n, registers); n < n2; n += 4) {
            floatArrayList.addFloat(ArrayDecoders.decodeFloat(byArray, n));
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedDoubleList(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        DoubleArrayList doubleArrayList = (DoubleArrayList)protobufList;
        int n2 = n + registers.int1;
        for (n = ArrayDecoders.decodeVarint32(byArray, n, registers); n < n2; n += 8) {
            doubleArrayList.addDouble(ArrayDecoders.decodeDouble(byArray, n));
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedBoolList(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        BooleanArrayList booleanArrayList = (BooleanArrayList)protobufList;
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = n + registers.int1;
        while (n < n2) {
            n = ArrayDecoders.decodeVarint64(byArray, n, registers);
            booleanArrayList.addBoolean(registers.long1 != 0L);
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedSInt32List(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)protobufList;
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = n + registers.int1;
        while (n < n2) {
            n = ArrayDecoders.decodeVarint32(byArray, n, registers);
            intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodePackedSInt64List(byte[] byArray, int n, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)protobufList;
        n = ArrayDecoders.decodeVarint32(byArray, n, registers);
        int n2 = n + registers.int1;
        while (n < n2) {
            n = ArrayDecoders.decodeVarint64(byArray, n, registers);
            longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        if (n != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return n;
    }

    static int decodeStringList(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n4 = registers.int1;
        if (n4 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n4 == 0) {
            protobufList2.add("");
        } else {
            String string = new String(byArray, n2, n4, Internal.UTF_8);
            protobufList2.add(string);
            n2 += n4;
        }
        while (n2 < n3) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint32(byArray, n5, registers);
            int n6 = registers.int1;
            if (n6 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n6 == 0) {
                protobufList2.add("");
                continue;
            }
            String string = new String(byArray, n2, n6, Internal.UTF_8);
            protobufList2.add(string);
            n2 += n6;
        }
        return n2;
    }

    static int decodeStringListRequireUtf8(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n4 = registers.int1;
        if (n4 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n4 == 0) {
            protobufList2.add("");
        } else {
            if (!Utf8.isValidUtf8(byArray, n2, n2 + n4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(byArray, n2, n4, Internal.UTF_8);
            protobufList2.add(string);
            n2 += n4;
        }
        while (n2 < n3) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint32(byArray, n5, registers);
            int n6 = registers.int1;
            if (n6 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n6 == 0) {
                protobufList2.add("");
                continue;
            }
            if (!Utf8.isValidUtf8(byArray, n2, n2 + n6)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(byArray, n2, n6, Internal.UTF_8);
            protobufList2.add(string);
            n2 += n6;
        }
        return n2;
    }

    static int decodeBytesList(int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
        int n4 = registers.int1;
        if (n4 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n4 > byArray.length - n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n4 == 0) {
            protobufList2.add(ByteString.EMPTY);
        } else {
            protobufList2.add(ByteString.copyFrom(byArray, n2, n4));
            n2 += n4;
        }
        while (n2 < n3) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeVarint32(byArray, n5, registers);
            int n6 = registers.int1;
            if (n6 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n6 > byArray.length - n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (n6 == 0) {
                protobufList2.add(ByteString.EMPTY);
                continue;
            }
            protobufList2.add(ByteString.copyFrom(byArray, n2, n6));
            n2 += n6;
        }
        return n2;
    }

    static int decodeMessageList(Schema<?> schema, int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        n2 = ArrayDecoders.decodeMessageField(schema, byArray, n2, n3, registers);
        protobufList2.add(registers.object1);
        while (n2 < n3) {
            int n4 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeMessageField(schema, byArray, n4, n3, registers);
            protobufList2.add(registers.object1);
        }
        return n2;
    }

    static int decodeGroupList(Schema schema, int n, byte[] byArray, int n2, int n3, Internal.ProtobufList<?> protobufList, Registers registers) throws IOException {
        Internal.ProtobufList<?> protobufList2 = protobufList;
        int n4 = n & 0xFFFFFFF8 | 4;
        n2 = ArrayDecoders.decodeGroupField(schema, byArray, n2, n3, n4, registers);
        protobufList2.add(registers.object1);
        while (n2 < n3) {
            int n5 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
            if (n != registers.int1) break;
            n2 = ArrayDecoders.decodeGroupField(schema, byArray, n5, n3, n4, registers);
            protobufList2.add(registers.object1);
        }
        return n2;
    }

    static int decodeExtensionOrUnknownField(int n, byte[] byArray, int n2, int n3, Object object, MessageLite messageLite, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        int n4 = n >>> 3;
        GeneratedMessageLite.GeneratedExtension<MessageLite, ?> generatedExtension = registers.extensionRegistry.findLiteExtensionByNumber(messageLite, n4);
        if (generatedExtension == null) {
            return ArrayDecoders.decodeUnknownField(n, byArray, n2, n3, MessageSchema.getMutableUnknownFields(object), registers);
        }
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet = ((GeneratedMessageLite.ExtendableMessage)object).ensureExtensionsAreMutable();
        return ArrayDecoders.decodeExtension(n, byArray, n2, n3, (GeneratedMessageLite.ExtendableMessage)object, generatedExtension, unknownFieldSchema, registers);
    }

    static int decodeExtension(int n, byte[] byArray, int n2, int n3, GeneratedMessageLite.ExtendableMessage<?, ?> extendableMessage, GeneratedMessageLite.GeneratedExtension<?, ?> generatedExtension, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        block40: {
            int n4;
            FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet;
            block39: {
                fieldSet = extendableMessage.extensions;
                n4 = n >>> 3;
                if (!generatedExtension.descriptor.isRepeated() || !generatedExtension.descriptor.isPacked()) break block39;
                switch (generatedExtension.getLiteType()) {
                    case DOUBLE: {
                        DoubleArrayList doubleArrayList = new DoubleArrayList();
                        n2 = ArrayDecoders.decodePackedDoubleList(byArray, n2, doubleArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, doubleArrayList);
                        break block40;
                    }
                    case FLOAT: {
                        FloatArrayList floatArrayList = new FloatArrayList();
                        n2 = ArrayDecoders.decodePackedFloatList(byArray, n2, floatArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, floatArrayList);
                        break block40;
                    }
                    case INT64: 
                    case UINT64: {
                        LongArrayList longArrayList = new LongArrayList();
                        n2 = ArrayDecoders.decodePackedVarint64List(byArray, n2, longArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, longArrayList);
                        break block40;
                    }
                    case INT32: 
                    case UINT32: {
                        IntArrayList intArrayList = new IntArrayList();
                        n2 = ArrayDecoders.decodePackedVarint32List(byArray, n2, intArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        LongArrayList longArrayList = new LongArrayList();
                        n2 = ArrayDecoders.decodePackedFixed64List(byArray, n2, longArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, longArrayList);
                        break block40;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        IntArrayList intArrayList = new IntArrayList();
                        n2 = ArrayDecoders.decodePackedFixed32List(byArray, n2, intArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    case BOOL: {
                        BooleanArrayList booleanArrayList = new BooleanArrayList();
                        n2 = ArrayDecoders.decodePackedBoolList(byArray, n2, booleanArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, booleanArrayList);
                        break block40;
                    }
                    case SINT32: {
                        IntArrayList intArrayList = new IntArrayList();
                        n2 = ArrayDecoders.decodePackedSInt32List(byArray, n2, intArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    case SINT64: {
                        LongArrayList longArrayList = new LongArrayList();
                        n2 = ArrayDecoders.decodePackedSInt64List(byArray, n2, longArrayList, registers);
                        fieldSet.setField(generatedExtension.descriptor, longArrayList);
                        break block40;
                    }
                    case ENUM: {
                        IntArrayList intArrayList = new IntArrayList();
                        n2 = ArrayDecoders.decodePackedVarint32List(byArray, n2, intArrayList, registers);
                        SchemaUtil.filterUnknownEnumList(extendableMessage, n4, (List<Integer>)intArrayList, generatedExtension.descriptor.getEnumType(), null, unknownFieldSchema);
                        fieldSet.setField(generatedExtension.descriptor, intArrayList);
                        break block40;
                    }
                    default: {
                        throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)generatedExtension.descriptor.getLiteType()));
                    }
                }
            }
            Object object = null;
            if (generatedExtension.getLiteType() == WireFormat.FieldType.ENUM) {
                n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                Object obj = generatedExtension.descriptor.getEnumType().findValueByNumber(registers.int1);
                if (obj == null) {
                    SchemaUtil.storeUnknownEnum(extendableMessage, n4, registers.int1, null, unknownFieldSchema);
                    return n2;
                }
                object = registers.int1;
            } else {
                switch (generatedExtension.getLiteType()) {
                    case DOUBLE: {
                        object = ArrayDecoders.decodeDouble(byArray, n2);
                        n2 += 8;
                        break;
                    }
                    case FLOAT: {
                        object = Float.valueOf(ArrayDecoders.decodeFloat(byArray, n2));
                        n2 += 4;
                        break;
                    }
                    case INT64: 
                    case UINT64: {
                        n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
                        object = registers.long1;
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                        object = registers.int1;
                        break;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        object = ArrayDecoders.decodeFixed64(byArray, n2);
                        n2 += 8;
                        break;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        object = ArrayDecoders.decodeFixed32(byArray, n2);
                        n2 += 4;
                        break;
                    }
                    case BOOL: {
                        n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
                        object = registers.long1 != 0L;
                        break;
                    }
                    case BYTES: {
                        n2 = ArrayDecoders.decodeBytes(byArray, n2, registers);
                        object = registers.object1;
                        break;
                    }
                    case SINT32: {
                        n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                        object = CodedInputStream.decodeZigZag32(registers.int1);
                        break;
                    }
                    case SINT64: {
                        n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
                        object = CodedInputStream.decodeZigZag64(registers.long1);
                        break;
                    }
                    case STRING: {
                        n2 = ArrayDecoders.decodeString(byArray, n2, registers);
                        object = registers.object1;
                        break;
                    }
                    case GROUP: {
                        int n5 = n4 << 3 | 4;
                        Schema<Class<?>> schema = Protobuf.getInstance().schemaFor(generatedExtension.getMessageDefaultInstance().getClass());
                        if (generatedExtension.isRepeated()) {
                            n2 = ArrayDecoders.decodeGroupField(schema, byArray, n2, n3, n5, registers);
                            fieldSet.addRepeatedField(generatedExtension.descriptor, registers.object1);
                        } else {
                            Class<?> clazz = fieldSet.getField(generatedExtension.descriptor);
                            if (clazz == null) {
                                clazz = schema.newInstance();
                                fieldSet.setField(generatedExtension.descriptor, clazz);
                            }
                            n2 = ArrayDecoders.mergeGroupField(clazz, schema, byArray, n2, n3, n5, registers);
                        }
                        return n2;
                    }
                    case MESSAGE: {
                        Schema<Class<?>> schema = Protobuf.getInstance().schemaFor(generatedExtension.getMessageDefaultInstance().getClass());
                        if (generatedExtension.isRepeated()) {
                            n2 = ArrayDecoders.decodeMessageField(schema, byArray, n2, n3, registers);
                            fieldSet.addRepeatedField(generatedExtension.descriptor, registers.object1);
                        } else {
                            Class<?> clazz = fieldSet.getField(generatedExtension.descriptor);
                            if (clazz == null) {
                                clazz = schema.newInstance();
                                fieldSet.setField(generatedExtension.descriptor, clazz);
                            }
                            n2 = ArrayDecoders.mergeMessageField(clazz, schema, byArray, n2, n3, registers);
                        }
                        return n2;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (generatedExtension.isRepeated()) {
                fieldSet.addRepeatedField(generatedExtension.descriptor, object);
            } else {
                fieldSet.setField(generatedExtension.descriptor, object);
            }
        }
        return n2;
    }

    static int decodeUnknownField(int n, byte[] byArray, int n2, int n3, UnknownFieldSetLite unknownFieldSetLite, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(n) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
                unknownFieldSetLite.storeField(n, registers.long1);
                return n2;
            }
            case 5: {
                unknownFieldSetLite.storeField(n, ArrayDecoders.decodeFixed32(byArray, n2));
                return n2 + 4;
            }
            case 1: {
                unknownFieldSetLite.storeField(n, ArrayDecoders.decodeFixed64(byArray, n2));
                return n2 + 8;
            }
            case 2: {
                n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                int n4 = registers.int1;
                if (n4 < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (n4 > byArray.length - n2) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if (n4 == 0) {
                    unknownFieldSetLite.storeField(n, ByteString.EMPTY);
                } else {
                    unknownFieldSetLite.storeField(n, ByteString.copyFrom(byArray, n2, n4));
                }
                return n2 + n4;
            }
            case 3: {
                UnknownFieldSetLite unknownFieldSetLite2 = UnknownFieldSetLite.newInstance();
                int n5 = n & 0xFFFFFFF8 | 4;
                int n6 = 0;
                while (n2 < n3) {
                    n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                    n6 = registers.int1;
                    if (n6 == n5) break;
                    n2 = ArrayDecoders.decodeUnknownField(n6, byArray, n2, n3, unknownFieldSetLite2, registers);
                }
                if (n2 > n3 || n6 != n5) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                unknownFieldSetLite.storeField(n, unknownFieldSetLite2);
                return n2;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static int skipField(int n, byte[] byArray, int n2, int n3, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(n) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                n2 = ArrayDecoders.decodeVarint64(byArray, n2, registers);
                return n2;
            }
            case 5: {
                return n2 + 4;
            }
            case 1: {
                return n2 + 8;
            }
            case 2: {
                n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                return n2 + registers.int1;
            }
            case 3: {
                int n4 = n & 0xFFFFFFF8 | 4;
                int n5 = 0;
                while (n2 < n3) {
                    n2 = ArrayDecoders.decodeVarint32(byArray, n2, registers);
                    n5 = registers.int1;
                    if (n5 == n4) break;
                    n2 = ArrayDecoders.skipField(n5, byArray, n2, n3, registers);
                }
                if (n2 > n3 || n5 != n4) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return n2;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static final class Registers {
        public int int1;
        public long long1;
        public Object object1;
        public final ExtensionRegistryLite extensionRegistry;

        Registers() {
            this.extensionRegistry = ExtensionRegistryLite.getEmptyRegistry();
        }

        Registers(ExtensionRegistryLite extensionRegistryLite) {
            if (extensionRegistryLite == null) {
                throw new NullPointerException();
            }
            this.extensionRegistry = extensionRegistryLite;
        }
    }
}

