/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.rest;

import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistry;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.internal.JavaDataExtractor;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.rest.MATLABParams;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class MATLABResult<T> {
    private MWAttributesContainer mwAttributesContainer;
    private MATLABResult.MATLAB_Result mlResult;
    private int nargout;
    private boolean hasNargout;
    private Class targetType;

    public static MATLABResult newInstance(MATLABParams mATLABParams, InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        if (mATLABParams == null) {
            throw new IllegalArgumentException("MATLAB Params object is required");
        }
        MATLABResult mATLABResult = new MATLABResult();
        CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        MATLABArray.registerAllExtensions(extensionRegistry);
        mATLABResult.mwAttributesContainer = new MWAttributesContainer(mATLABParams.getMwMarshalingRules());
        mATLABResult.nargout = mATLABParams.getNargout();
        mATLABResult.targetType = mATLABParams.getTargetType();
        mATLABResult.hasNargout = mATLABResult.nargout > 1;
        try {
            mATLABResult.mlResult = MATLABResult.MATLAB_Result.parseFrom(codedInputStream, (ExtensionRegistryLite)extensionRegistry);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to parse the input stream object. Please make sure that you are using right class to parse the object", iOException);
        }
        return mATLABResult;
    }

    public static MATLABResult newInstance(MATLABParams mATLABParams, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("byte array is null");
        }
        if (mATLABParams == null) {
            throw new IllegalArgumentException("MATLAB Params object is required");
        }
        MATLABResult mATLABResult = new MATLABResult();
        mATLABResult.mwAttributesContainer = new MWAttributesContainer(mATLABParams.getMwMarshalingRules());
        mATLABResult.nargout = mATLABParams.getNargout();
        mATLABResult.targetType = mATLABParams.getTargetType();
        mATLABResult.hasNargout = mATLABResult.nargout > 1;
        try {
            mATLABResult.mlResult = MATLABResult.MATLAB_Result.parseFrom(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to parse the byte array. Please make sure that you are using right class to parse the byte array", iOException);
        }
        return mATLABResult;
    }

    public <T> T getResult() throws MATLABException {
        if (!this.mlResult.hasError()) {
            if (this.mlResult.getLhsCount() != this.nargout) {
                throw new IllegalArgumentException("Incorrect number of outputs returned from MATLAB.\nMATLAB returned " + this.mlResult.getLhsCount() + " number of outputs,\nMethod ,, expected " + this.nargout + " number of outputs.");
            }
        } else {
            MATLABError.MATLAB_Error mATLAB_Error = this.mlResult.getError();
            throw new MATLABException(mATLAB_Error.getMessage(), mATLAB_Error.getIdentifier(), MWInvocationHandlerUtils.convertToMATLABStackFrameList(mATLAB_Error.getStackList()));
        }
        List<MATLABArray.MATLAB_Array> list = this.mlResult.getLhsList();
        if (list.size() == 0) {
            return null;
        }
        JavaDataExtractor javaDataExtractor = new JavaDataExtractor(this.mwAttributesContainer);
        Object[] objectArray = new Object[list.size()];
        Class clazz = this.hasNargout ? Object.class : this.targetType;
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = javaDataExtractor.toJavaType(list.get(i), clazz);
        }
        return this.hasNargout ? this.targetType.cast(objectArray) : this.targetType.cast(objectArray[0]);
    }
}

