/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.methods.HttpGet;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.mps.client.internal.async.WaitNotifier;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstanceInfo {
    private final UUID instanceUUID;
    private final String location;
    private String serverUri;
    private String sessionId;
    private volatile long since;
    private volatile FutureCallback<HttpResponse> notificationCallback;
    private WaitNotifier waitNotifier;
    public AtomicBoolean notificationRecent;
    public HttpGet httpGet;
    private HttpClientContext httpContext;
    public final Object lock = new Object();

    public String getServerUri() {
        return this.serverUri;
    }

    public UUID getUuid() {
        return this.instanceUUID;
    }

    public String getLocation() {
        return this.location;
    }

    public long getCurrentSeq() {
        return this.since;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setCurrentSeq(long l) {
        this.since = l;
    }

    public void updateSessionId(String string) {
        this.sessionId = string;
    }

    public InstanceInfo(UUID uUID, String string, int n, String string2, HttpClientContext httpClientContext) throws URISyntaxException {
        this.instanceUUID = uUID;
        this.location = string + "/~" + uUID + "/";
        this.serverUri = string;
        this.since = n;
        this.sessionId = string2;
        this.notificationRecent = new AtomicBoolean(true);
        this.httpContext = httpClientContext;
        this.waitNotifier = new WaitNotifier();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo instanceInfo = (InstanceInfo)object;
        return !(this.instanceUUID == null ? instanceInfo.instanceUUID != null : !this.instanceUUID.equals(instanceInfo.instanceUUID));
    }

    public boolean isNotificationRunning() {
        return this.notificationCallback != null;
    }

    public void setNotificationRunningTrue(FutureCallback<HttpResponse> futureCallback) {
        this.notificationCallback = futureCallback;
    }

    public void setNotificationRunningFalse() {
        this.notificationCallback = null;
    }

    public FutureCallback<HttpResponse> getNotificationCallback() {
        return this.notificationCallback;
    }

    public HttpClientContext getHttpContext() {
        return this.httpContext;
    }

    public String toString() {
        return String.format("Server URL: %s, Session ID: %s", this.location, this.sessionId);
    }

    public WaitNotifier getWaitNotifier() {
        return this.waitNotifier;
    }
}

