/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.Flattener;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABPrimitiveArrayBuilder;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MATLABArrayBuilder {
    private static final List<Class> flattenedDataClassTypes = new ArrayList<Class>();
    private final MWAttributesContainer mwAttributesContainer;

    public MATLABArrayBuilder(MWAttributesContainer mWAttributesContainer) {
        this.mwAttributesContainer = mWAttributesContainer;
    }

    public MATLABArray.MATLAB_Array arrayFromData(Object object) {
        return this.flattenAndIdentifyNextType(object, Method.class);
    }

    private MATLABArray.MATLAB_Array flattenAndIdentifyNextType(Object object, Class clazz) {
        Map<Class, Map<String, Method>> map = this.mwAttributesContainer.getChildrenStructsForParentMLInput(clazz);
        if (object == null) {
            return this.createEmptyMATLABArray();
        }
        MATLABArray.MATLAB_Array.Builder builder = MATLABArray.MATLAB_Array.newBuilder();
        Class<?> clazz2 = object.getClass();
        Object object2 = null;
        Method method = null;
        try {
            method = Flattener.class.getMethod("flatten", clazz2);
            object2 = method.invoke(null, object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                object2 = Flattener.flatten(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (map.containsKey(object.getClass())) {
                    builder.addAllDimension(Arrays.asList(1L, 1L));
                    this.updateMATLABArrayBuilderStruct(builder, new Object[]{object}, map);
                    return builder.build();
                }
                throw illegalArgumentException;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Trouble processing input data of type : " + clazz2.getName() + "\n", exception);
        }
        List<Integer> list = MATLABArrayBuilder.getDimensions(object);
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            int n = object3.next();
            builder.addDimension(n);
        }
        try {
            object3 = object2.getClass();
            if (flattenedDataClassTypes.contains(object3)) {
                MATLABPrimitiveArrayBuilder.newInstance(object2, builder, (Class)object3);
            } else {
                this.updateMATLABObjectArrayBuilder((Object[])object2, builder, clazz);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Trouble creating MATLABArray from input data.\n", exception);
        }
        return builder.build();
    }

    public static List<Integer> getDimensions(Object object) {
        if (!object.getClass().isArray()) {
            if (object.getClass() == String.class) {
                return Arrays.asList(1, ((String)object).length());
            }
            return Arrays.asList(1, 1);
        }
        List<Integer> list = ArrayUtils.getDimsArray(object);
        if (list.size() == 1) {
            return Arrays.asList(1, list.get(0));
        }
        return list;
    }

    private void updateMATLABObjectArrayBuilder(Object[] objectArray, MATLABArray.MATLAB_Array.Builder builder, Class clazz) {
        Map<Class, Map<String, Method>> map = this.mwAttributesContainer.getChildrenStructsForParentMLInput(clazz);
        if (map.containsKey(objectArray.getClass().getComponentType())) {
            this.updateMATLABArrayBuilderStruct(builder, objectArray, map);
        } else {
            this.updateMATLABArrayBuilderCell(builder, objectArray, clazz);
        }
    }

    private void updateMATLABArrayBuilderStruct(MATLABArray.MATLAB_Array.Builder builder, Object[] objectArray, Map<Class, Map<String, Method>> map) {
        builder.setType(MATLABArray.MATLAB_Array.MWType.STRUCT);
        Class<?> clazz = objectArray[0].getClass();
        Map<String, Method> map2 = map.get(clazz);
        MATLABArray.MATLAB_Array.Struct.Builder builder2 = MATLABArray.MATLAB_Array.Struct.newBuilder();
        Set<String> set = map2.keySet();
        builder2.addAllFieldNames(set);
        for (Object object : objectArray) {
            for (String string : set) {
                try {
                    Object object2 = null;
                    if (object != null) {
                        object2 = map2.get(string).invoke(object, new Object[0]);
                    }
                    builder2.addElements(this.flattenAndIdentifyNextType(object2, clazz));
                }
                catch (Exception exception) {
                    throw new RuntimeException("An error occurred while marshaling Java type : " + clazz.getName() + ", into MATLAB structure. The error occurred while marshaling the value of property : " + string + ", of this Java type.", exception);
                }
            }
        }
        builder.setStruct(builder2.build());
    }

    private void updateMATLABArrayBuilderCell(MATLABArray.MATLAB_Array.Builder builder, Object[] objectArray, Class clazz) {
        builder.setType(MATLABArray.MATLAB_Array.MWType.CELL);
        MATLABArray.MATLAB_Array.Cell.Builder builder2 = MATLABArray.MATLAB_Array.Cell.newBuilder();
        for (Object object : objectArray) {
            builder2.addElements(this.flattenAndIdentifyNextType(object, clazz));
        }
        builder.setCell(builder2.build());
    }

    private MATLABArray.MATLAB_Array createEmptyMATLABArray() {
        MATLABArray.MATLAB_Array.Builder builder = MATLABArray.MATLAB_Array.newBuilder();
        builder.setType(MATLABArray.MATLAB_Array.MWType.DOUBLE);
        builder.addDimension(0L);
        builder.addDimension(0L);
        MATLABArray.MATLAB_Array.Double.Builder builder2 = MATLABArray.MATLAB_Array.Double.newBuilder();
        builder.setMwdouble(builder2.build());
        return builder.build();
    }

    static {
        Collections.addAll(flattenedDataClassTypes, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class, String[].class);
    }
}

