/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayUtils {
    private static Map<String, String> classNameToCamelCase = new HashMap<String, String>();
    private static Map<Class, Class> boxedTypeToPrimitiveType = ArrayUtils.createBoxedToUnBoxedTypeMap();

    public static Class getArrayElementType(Object object) {
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = clazz = object.getClass() == Class.class ? (Class<?>)object : object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static List<Integer> getDimsArray(Object object) {
        if (object == null) {
            return null;
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Input must be an array");
        }
        if (ArrayUtils.isOneDimArray(object)) {
            return Arrays.asList(Array.getLength(object));
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length == 0) {
            return Arrays.asList(0);
        }
        List<Integer> list = ArrayUtils.getDimsArray(objectArray[0]);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size() + 1);
        arrayList.add(0, objectArray.length);
        arrayList.addAll(1, list);
        return arrayList;
    }

    public static List<Integer> getStrides(List<Integer> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size() + 1);
        arrayList.add(1);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(i + 1, (Integer)arrayList.get(i) * list.get(i));
        }
        return arrayList;
    }

    public static boolean isOneDimArray(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().isArray() && !object.getClass().getComponentType().isArray();
    }

    public static String getCamelCasedClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        String string2 = classNameToCamelCase.get(string);
        if (string2 == null) {
            String[] stringArray = string.split("\\.");
            string2 = "";
            for (String string3 : stringArray) {
                string2 = string2 + string3.substring(0, 1).toUpperCase() + string3.substring(1);
            }
            classNameToCamelCase.put(string, string2);
        }
        return string2;
    }

    public static Class unBoxIfBoxedType(Class clazz) {
        Class clazz2 = boxedTypeToPrimitiveType.get(clazz);
        return clazz2 == null ? clazz : clazz2;
    }

    public static Map<Class, Class> createBoxedToUnBoxedTypeMap() {
        HashMap<Class, Class> hashMap = new HashMap<Class, Class>();
        hashMap.put(Boolean.class, Boolean.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Integer.class, Integer.TYPE);
        hashMap.put(Character.class, Character.TYPE);
        hashMap.put(Float.class, Float.TYPE);
        hashMap.put(Long.class, Long.TYPE);
        hashMap.put(Byte.class, Byte.TYPE);
        hashMap.put(Short.class, Short.TYPE);
        return hashMap;
    }

    public static List<Integer> convertToIntegerList(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n : nArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    public static List<Short> convertToShortList(List<Integer> list) {
        ArrayList<Short> arrayList = new ArrayList<Short>(list.size());
        for (Integer n : list) {
            arrayList.add(n.shortValue());
        }
        return arrayList;
    }

    public static <T> T[] convertToArray(List<?> list, Class<T> clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, list.size());
        objectArray = list.toArray(objectArray);
        return objectArray;
    }

    public static <T> Object toPrimitiveArray(Object[] objectArray, Class<T> clazz) {
        Object object = Array.newInstance(clazz, objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Array.set(object, i, objectArray[i]);
        }
        return object;
    }

    public static int[] toIntArray(Long[] longArray) {
        int[] nArray = new int[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            nArray[i] = longArray[i].intValue();
        }
        return nArray;
    }

    public static char[] toCharArray(Integer[] integerArray) {
        char[] cArray = new char[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            cArray[i] = (char)integerArray[i].intValue();
        }
        return cArray;
    }

    public static Character[] toCharacterArray(Integer[] integerArray) {
        Character[] characterArray = new Character[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            characterArray[i] = Character.valueOf((char)integerArray[i].intValue());
        }
        return characterArray;
    }

    public static Byte[] toBoxedArray(byte[] byArray) {
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public static boolean coerceDimsList(List<Long> list, int n) {
        if (n < list.size()) {
            return ArrayUtils.shrinkDimensionsList(list, n);
        }
        return ArrayUtils.expandDimensionsList(list, n);
    }

    private static boolean expandDimensionsList(List<Long> list, int n) {
        while (n > list.size()) {
            list.add(1L);
        }
        return true;
    }

    private static boolean shrinkDimensionsList(List<Long> list, int n) {
        while (n < list.size()) {
            if (ArrayUtils.removeRightMostOne(list) || ArrayUtils.removeLeftMostOne(list)) continue;
            return false;
        }
        return true;
    }

    private static boolean removeRightMostOne(List<Long> list) {
        int n = list.size() - 1;
        if (list.get(n) == 1L) {
            list.remove(n);
            return true;
        }
        return false;
    }

    private static boolean removeLeftMostOne(List<Long> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != 1L) continue;
            list.remove(i);
            bl = true;
            break;
        }
        return bl;
    }

    public static int getNumberOfDimensions(Object object) {
        Class<?> clazz = object.getClass() == Class.class ? (Class<?>)object : object.getClass();
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        return n;
    }
}

