/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.AbstractMessage;
import com.mathworks.google.protobuf.MapEntry;
import com.mathworks.google.protobuf.MapField;
import com.mathworks.google.protobuf.MapFieldLite;
import com.mathworks.google.protobuf.MapFieldReflectionAccessor;
import com.mathworks.google.protobuf.Message;
import com.mathworks.google.protobuf.MessageOrBuilder;
import com.mathworks.google.protobuf.MutabilityOracle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapFieldBuilder<KeyT, MessageOrBuilderT extends MessageOrBuilder, MessageT extends MessageOrBuilderT, BuilderT extends MessageOrBuilderT>
extends MapFieldReflectionAccessor {
    Map<KeyT, MessageOrBuilderT> builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>();
    Map<KeyT, MessageT> messageMap = null;
    List<Message> messageList = null;
    Converter<KeyT, MessageOrBuilderT, MessageT> converter;

    public MapFieldBuilder(Converter<KeyT, MessageOrBuilderT, MessageT> converter) {
        this.converter = converter;
    }

    private List<MapEntry<KeyT, MessageT>> getMapEntryList() {
        ArrayList<MapEntry<KeyT, MessageT>> arrayList = new ArrayList<MapEntry<KeyT, MessageT>>(this.messageList.size());
        Class<?> clazz = ((MessageOrBuilder)this.converter.defaultEntry().getValue()).getClass();
        for (Message message : this.messageList) {
            MapEntry mapEntry = (MapEntry)message;
            if (clazz.isInstance(mapEntry.getValue())) {
                arrayList.add(mapEntry);
                continue;
            }
            arrayList.add((MapEntry<KeyT, MessageT>)((MapEntry.Builder)((AbstractMessage.Builder)this.converter.defaultEntry().toBuilder()).mergeFrom(message)).build());
        }
        return arrayList;
    }

    public Map<KeyT, MessageOrBuilderT> ensureBuilderMap() {
        if (this.builderMap != null) {
            return this.builderMap;
        }
        if (this.messageMap != null) {
            this.builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>(this.messageMap.size());
            for (Map.Entry<KeyT, MessageT> entry : this.messageMap.entrySet()) {
                this.builderMap.put(entry.getKey(), entry.getValue());
            }
            this.messageMap = null;
            return this.builderMap;
        }
        this.builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>(this.messageList.size());
        for (MapEntry<KeyT, MessageT> mapEntry : this.getMapEntryList()) {
            this.builderMap.put(mapEntry.getKey(), mapEntry.getValue());
        }
        this.messageList = null;
        return this.builderMap;
    }

    public List<Message> ensureMessageList() {
        if (this.messageList != null) {
            return this.messageList;
        }
        if (this.builderMap != null) {
            this.messageList = new ArrayList<Message>(this.builderMap.size());
            for (Map.Entry<KeyT, MessageOrBuilderT> entry : this.builderMap.entrySet()) {
                this.messageList.add(((MapEntry.Builder)this.converter.defaultEntry().toBuilder()).setKey(entry.getKey()).setValue(this.converter.build((MessageOrBuilder)entry.getValue())).build());
            }
            this.builderMap = null;
            return this.messageList;
        }
        this.messageList = new ArrayList<Message>(this.messageMap.size());
        for (Map.Entry<KeyT, MessageT> entry : this.messageMap.entrySet()) {
            this.messageList.add(((MapEntry.Builder)this.converter.defaultEntry().toBuilder()).setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        this.messageMap = null;
        return this.messageList;
    }

    public Map<KeyT, MessageT> ensureMessageMap() {
        this.messageMap = this.populateMutableMap();
        this.builderMap = null;
        this.messageList = null;
        return this.messageMap;
    }

    public Map<KeyT, MessageT> getImmutableMap() {
        return new MapField.MutabilityAwareMap<KeyT, MessageT>(MutabilityOracle.IMMUTABLE, this.populateMutableMap());
    }

    private Map<KeyT, MessageT> populateMutableMap() {
        if (this.messageMap != null) {
            return this.messageMap;
        }
        if (this.builderMap != null) {
            LinkedHashMap<KeyT, MessageT> linkedHashMap = new LinkedHashMap<KeyT, MessageT>(this.builderMap.size());
            for (Map.Entry<KeyT, MessageOrBuilderT> entry : this.builderMap.entrySet()) {
                linkedHashMap.put(entry.getKey(), this.converter.build((MessageOrBuilder)entry.getValue()));
            }
            return linkedHashMap;
        }
        LinkedHashMap<KeyT, MessageT> linkedHashMap = new LinkedHashMap<KeyT, MessageT>(this.messageList.size());
        for (MapEntry<KeyT, MessageT> mapEntry : this.getMapEntryList()) {
            linkedHashMap.put(mapEntry.getKey(), mapEntry.getValue());
        }
        return linkedHashMap;
    }

    public void mergeFrom(MapField<KeyT, MessageT> mapField) {
        this.ensureBuilderMap().putAll(MapFieldLite.copy(mapField.getMap()));
    }

    public void clear() {
        this.builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>();
        this.messageMap = null;
        this.messageList = null;
    }

    private boolean typedEquals(MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT> mapFieldBuilder) {
        return MapFieldLite.equals(this.ensureBuilderMap(), mapFieldBuilder.ensureBuilderMap());
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapFieldBuilder)) {
            return false;
        }
        return this.typedEquals((MapFieldBuilder)object);
    }

    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this.ensureBuilderMap());
    }

    public MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT> copy() {
        MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT> mapFieldBuilder = new MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT>(this.converter);
        mapFieldBuilder.ensureBuilderMap().putAll(this.ensureBuilderMap());
        return mapFieldBuilder;
    }

    public MapField<KeyT, MessageT> build(MapEntry<KeyT, MessageT> mapEntry) {
        MapField<KeyT, MessageT> mapField = MapField.newMapField(mapEntry);
        Map<KeyT, MessageT> map = mapField.getMutableMap();
        for (Map.Entry<KeyT, MessageOrBuilderT> entry : this.ensureBuilderMap().entrySet()) {
            map.put(entry.getKey(), this.converter.build((MessageOrBuilder)entry.getValue()));
        }
        mapField.makeImmutable();
        return mapField;
    }

    @Override
    List<Message> getList() {
        return this.ensureMessageList();
    }

    @Override
    List<Message> getMutableList() {
        return this.ensureMessageList();
    }

    @Override
    Message getMapEntryMessageDefaultInstance() {
        return this.converter.defaultEntry();
    }

    public static interface Converter<KeyT, MessageOrBuilderT extends MessageOrBuilder, MessageT extends MessageOrBuilderT> {
        public MessageT build(MessageOrBuilderT var1);

        public MapEntry<KeyT, MessageT> defaultEntry();
    }
}

