/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.ExtensionSchemas;
import com.mathworks.google.protobuf.GeneratedMessageInfoFactory;
import com.mathworks.google.protobuf.GeneratedMessageLite;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.ListFieldSchema;
import com.mathworks.google.protobuf.MapFieldSchemas;
import com.mathworks.google.protobuf.MessageInfo;
import com.mathworks.google.protobuf.MessageInfoFactory;
import com.mathworks.google.protobuf.MessageSchema;
import com.mathworks.google.protobuf.MessageSetSchema;
import com.mathworks.google.protobuf.NewInstanceSchemas;
import com.mathworks.google.protobuf.Schema;
import com.mathworks.google.protobuf.SchemaFactory;
import com.mathworks.google.protobuf.SchemaUtil;

@CheckReturnValue
final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory());
    }

    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        this.messageInfoFactory = Internal.checkNotNull(messageInfoFactory, "messageInfoFactory");
    }

    @Override
    public <T> Schema<T> createSchema(Class<T> clazz) {
        SchemaUtil.requireGeneratedMessage(clazz);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(clazz);
        if (messageInfo.isMessageSetWireFormat()) {
            if (GeneratedMessageLite.class.isAssignableFrom(clazz)) {
                return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance());
            }
            return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetFullSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
        }
        return ManifestSchemaFactory.newSchema(clazz, messageInfo);
    }

    private static <T> Schema<T> newSchema(Class<T> clazz, MessageInfo messageInfo) {
        if (GeneratedMessageLite.class.isAssignableFrom(clazz)) {
            return ManifestSchemaFactory.allowExtensions(messageInfo) ? MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite()) : MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
        }
        return ManifestSchemaFactory.allowExtensions(messageInfo) ? MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.unknownFieldSetFullSchema(), ExtensionSchemas.full(), MapFieldSchemas.full()) : MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.unknownFieldSetFullSchema(), null, MapFieldSchemas.full());
    }

    private static boolean allowExtensions(MessageInfo messageInfo) {
        switch (messageInfo.getSyntax()) {
            case PROTO3: {
                return false;
            }
        }
        return true;
    }

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        return new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory());
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        try {
            Class<?> clazz = Class.forName("com.mathworks.google.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return EMPTY_FACTORY;
        }
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        CompositeMessageInfoFactory(MessageInfoFactory ... messageInfoFactoryArray) {
            this.factories = messageInfoFactoryArray;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            for (MessageInfoFactory messageInfoFactory : this.factories) {
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            for (MessageInfoFactory messageInfoFactory : this.factories) {
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return messageInfoFactory.messageInfoFor(clazz);
            }
            throw new UnsupportedOperationException("No factory is available for message type: " + clazz.getName());
        }
    }
}

