/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.DescriptorProtos;
import com.mathworks.google.protobuf.ExtensionRegistry;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.google.protobuf.FieldSet;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.InvalidProtocolBufferException;
import com.mathworks.google.protobuf.JavaFeaturesProto;
import com.mathworks.google.protobuf.Message;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.TextFormat;
import com.mathworks.google.protobuf.WireFormat;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

@CheckReturnValue
public final class Descriptors {
    private static final Logger logger = Logger.getLogger(Descriptors.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Descriptor[] EMPTY_DESCRIPTORS = new Descriptor[0];
    private static final FieldDescriptor[] EMPTY_FIELD_DESCRIPTORS = new FieldDescriptor[0];
    private static final EnumDescriptor[] EMPTY_ENUM_DESCRIPTORS = new EnumDescriptor[0];
    private static final ServiceDescriptor[] EMPTY_SERVICE_DESCRIPTORS = new ServiceDescriptor[0];
    private static final OneofDescriptor[] EMPTY_ONEOF_DESCRIPTORS = new OneofDescriptor[0];
    private static final ConcurrentHashMap<Integer, DescriptorProtos.FeatureSet> FEATURE_CACHE = new ConcurrentHashMap();
    private static volatile DescriptorProtos.FeatureSetDefaults javaEditionDefaults = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static DescriptorProtos.FeatureSet getEditionDefaults(DescriptorProtos.Edition edition) {
        DescriptorProtos.FeatureSetDefaults.FeatureSetEditionDefault featureSetEditionDefault;
        Object object;
        Object object2;
        Descriptor descriptor = DescriptorProtos.FeatureSetDefaults.getDescriptor();
        FileDescriptor fileDescriptor = JavaFeaturesProto.getDescriptor();
        if (javaEditionDefaults == null) {
            object2 = Descriptors.class;
            // MONITORENTER : com.mathworks.google.protobuf.Descriptors.class
            if (javaEditionDefaults == null) {
                try {
                    object = ExtensionRegistry.newInstance();
                    ((ExtensionRegistry)object).add(JavaFeaturesProto.java);
                    javaEditionDefaults = DescriptorProtos.FeatureSetDefaults.parseFrom("\n\u0018\u0012\u0013\b\u0001\u0010\u0002\u0018\u0002 \u0003(\u00010\u0002\u00ca>\u0004\b\u0001\u0010\u0001\u0018\u00e6\u0007\n\u0018\u0012\u0013\b\u0002\u0010\u0001\u0018\u0001 \u0002(\u00010\u0001\u00ca>\u0004\b\u0000\u0010\u0001\u0018\u00e7\u0007\n\u0018\u0012\u0013\b\u0001\u0010\u0001\u0018\u0001 \u0002(\u00010\u0001\u00ca>\u0004\b\u0000\u0010\u0001\u0018\u00e8\u0007 \u00e6\u0007(\u00e8\u0007".getBytes(Internal.ISO_8859_1), (ExtensionRegistryLite)object);
                }
                catch (Exception exception) {
                    throw new AssertionError((Object)exception);
                }
            }
            // MONITOREXIT : object2
        }
        if (edition.getNumber() < javaEditionDefaults.getMinimumEdition().getNumber()) {
            throw new IllegalArgumentException("Edition " + edition + " is lower than the minimum supported edition " + javaEditionDefaults.getMinimumEdition() + "!");
        }
        if (edition.getNumber() > javaEditionDefaults.getMaximumEdition().getNumber()) {
            throw new IllegalArgumentException("Edition " + edition + " is greater than the maximum supported edition " + javaEditionDefaults.getMaximumEdition() + "!");
        }
        object2 = null;
        object = javaEditionDefaults.getDefaultsList().iterator();
        while (object.hasNext() && (featureSetEditionDefault = (DescriptorProtos.FeatureSetDefaults.FeatureSetEditionDefault)object.next()).getEdition().getNumber() <= edition.getNumber()) {
            object2 = featureSetEditionDefault.getFeatures();
        }
        if (object2 != null) return object2;
        throw new IllegalArgumentException("Edition " + edition + " does not have a valid default FeatureSet!");
    }

    private static DescriptorProtos.FeatureSet internFeatures(DescriptorProtos.FeatureSet featureSet) {
        DescriptorProtos.FeatureSet featureSet2 = FEATURE_CACHE.putIfAbsent(featureSet.hashCode(), featureSet);
        if (featureSet2 == null) {
            return featureSet;
        }
        return featureSet2;
    }

    private static String computeFullName(FileDescriptor fileDescriptor, Descriptor descriptor, String string) {
        if (descriptor != null) {
            return descriptor.getFullName() + '.' + string;
        }
        String string2 = fileDescriptor.getPackage();
        if (!string2.isEmpty()) {
            return string2 + '.' + string;
        }
        return string;
    }

    private static <T> T binarySearch(T[] TArray, int n, NumberGetter<T> numberGetter, int n2) {
        int n3 = 0;
        int n4 = n - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            T t = TArray[n5];
            int n6 = numberGetter.getNumber(t);
            if (n2 < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n2 > n6) {
                n3 = n5 + 1;
                continue;
            }
            return t;
        }
        return null;
    }

    private static interface NumberGetter<T> {
        public int getNumber(T var1);
    }

    public static final class OneofDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.OneofDescriptorProto proto;
        private volatile DescriptorProtos.OneofOptions options;
        private final String fullName;
        private final FileDescriptor file;
        private Descriptor containingType;
        private int fieldCount;
        private FieldDescriptor[] fields;

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.OneofOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.OneofOptions oneofOptions = this.proto.getOptions();
                if (oneofOptions.hasFeatures()) {
                    oneofOptions = oneofOptions.toBuilder().clearFeatures().build();
                }
                OneofDescriptor oneofDescriptor = this;
                synchronized (oneofDescriptor) {
                    if (this.options == null) {
                        this.options = oneofOptions;
                    }
                }
            }
            return this.options;
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public FieldDescriptor getField(int n) {
            return this.fields[n];
        }

        @Override
        public DescriptorProtos.OneofDescriptorProto toProto() {
            return this.proto;
        }

        boolean isSynthetic() {
            return this.fields.length == 1 && this.fields[0].isProto3Optional;
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
        }

        private void setProto(DescriptorProtos.OneofDescriptorProto oneofDescriptorProto) throws DescriptorValidationException {
            this.proto = oneofDescriptorProto;
            this.options = null;
            this.resolveFeatures(oneofDescriptorProto.getOptions().getFeatures());
        }

        private OneofDescriptor(DescriptorProtos.OneofDescriptorProto oneofDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n) {
            this.parent = descriptor;
            this.proto = oneofDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, oneofDescriptorProto.getName());
            this.file = fileDescriptor;
            this.index = n;
            this.containingType = descriptor;
            this.fieldCount = 0;
        }

        static /* synthetic */ FieldDescriptor[] access$2802(OneofDescriptor oneofDescriptor, FieldDescriptor[] fieldDescriptorArray) {
            oneofDescriptor.fields = fieldDescriptorArray;
            return fieldDescriptorArray;
        }
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private final boolean allowUnknownDependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();

        DescriptorPool(FileDescriptor[] fileDescriptorArray, boolean bl) {
            this.dependencies = Collections.newSetFromMap(new IdentityHashMap(fileDescriptorArray.length));
            this.allowUnknownDependencies = bl;
            for (FileDescriptor fileDescriptor : fileDescriptorArray) {
                this.dependencies.add(fileDescriptor);
                this.importPublicDependencies(fileDescriptor);
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                try {
                    this.addPackage(fileDescriptor.getPackage(), fileDescriptor);
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    throw new AssertionError((Object)descriptorValidationException);
                }
            }
        }

        private void importPublicDependencies(FileDescriptor fileDescriptor) {
            for (FileDescriptor fileDescriptor2 : fileDescriptor.getPublicDependencies()) {
                if (!this.dependencies.add(fileDescriptor2)) continue;
                this.importPublicDependencies(fileDescriptor2);
            }
        }

        GenericDescriptor findSymbol(String string) {
            return this.findSymbol(string, SearchFilter.ALL_SYMBOLS);
        }

        GenericDescriptor findSymbol(String string, SearchFilter searchFilter) {
            GenericDescriptor genericDescriptor = this.descriptorsByName.get(string);
            if (genericDescriptor != null && (searchFilter == SearchFilter.ALL_SYMBOLS || searchFilter == SearchFilter.TYPES_ONLY && this.isType(genericDescriptor) || searchFilter == SearchFilter.AGGREGATES_ONLY && this.isAggregate(genericDescriptor))) {
                return genericDescriptor;
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                genericDescriptor = ((FileDescriptor)fileDescriptor).pool.descriptorsByName.get(string);
                if (genericDescriptor == null || searchFilter != SearchFilter.ALL_SYMBOLS && (searchFilter != SearchFilter.TYPES_ONLY || !this.isType(genericDescriptor)) && (searchFilter != SearchFilter.AGGREGATES_ONLY || !this.isAggregate(genericDescriptor))) continue;
                return genericDescriptor;
            }
            return null;
        }

        boolean isType(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor;
        }

        boolean isAggregate(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor || genericDescriptor instanceof PackageDescriptor || genericDescriptor instanceof ServiceDescriptor;
        }

        GenericDescriptor lookupSymbol(String string, GenericDescriptor genericDescriptor, SearchFilter searchFilter) throws DescriptorValidationException {
            GenericDescriptor genericDescriptor2;
            String string2;
            if (string.startsWith(".")) {
                string2 = string.substring(1);
                genericDescriptor2 = this.findSymbol(string2, searchFilter);
            } else {
                int n = string.indexOf(46);
                String string3 = n == -1 ? string : string.substring(0, n);
                StringBuilder stringBuilder = new StringBuilder(genericDescriptor.getFullName());
                while (true) {
                    int n2;
                    if ((n2 = stringBuilder.lastIndexOf(".")) == -1) {
                        string2 = string;
                        genericDescriptor2 = this.findSymbol(string, searchFilter);
                        break;
                    }
                    stringBuilder.setLength(n2 + 1);
                    stringBuilder.append(string3);
                    genericDescriptor2 = this.findSymbol(stringBuilder.toString(), SearchFilter.AGGREGATES_ONLY);
                    if (genericDescriptor2 != null) {
                        if (n != -1) {
                            stringBuilder.setLength(n2 + 1);
                            stringBuilder.append(string);
                            genericDescriptor2 = this.findSymbol(stringBuilder.toString(), searchFilter);
                        }
                        string2 = stringBuilder.toString();
                        break;
                    }
                    stringBuilder.setLength(n2);
                }
            }
            if (genericDescriptor2 == null) {
                if (this.allowUnknownDependencies && searchFilter == SearchFilter.TYPES_ONLY) {
                    logger.warning("The descriptor for message type \"" + string + "\" cannot be found and a placeholder is created for it");
                    genericDescriptor2 = new Descriptor(string2);
                    this.dependencies.add(genericDescriptor2.getFile());
                    return genericDescriptor2;
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is not defined.");
            }
            return genericDescriptor2;
        }

        void addSymbol(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            DescriptorPool.validateSymbolName(genericDescriptor);
            String string = genericDescriptor.getFullName();
            GenericDescriptor genericDescriptor2 = this.descriptorsByName.put(string, genericDescriptor);
            if (genericDescriptor2 != null) {
                this.descriptorsByName.put(string, genericDescriptor2);
                if (genericDescriptor.getFile() == genericDescriptor2.getFile()) {
                    int n = string.lastIndexOf(46);
                    if (n == -1) {
                        throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is already defined.");
                    }
                    throw new DescriptorValidationException(genericDescriptor, '\"' + string.substring(n + 1) + "\" is already defined in \"" + string.substring(0, n) + "\".");
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is already defined in file \"" + genericDescriptor2.getFile().getName() + "\".");
            }
        }

        void addPackage(String string, FileDescriptor fileDescriptor) throws DescriptorValidationException {
            String string2;
            int n = string.lastIndexOf(46);
            if (n == -1) {
                string2 = string;
            } else {
                this.addPackage(string.substring(0, n), fileDescriptor);
                string2 = string.substring(n + 1);
            }
            GenericDescriptor genericDescriptor = this.descriptorsByName.put(string, new PackageDescriptor(string2, string, fileDescriptor));
            if (genericDescriptor != null) {
                this.descriptorsByName.put(string, genericDescriptor);
                if (!(genericDescriptor instanceof PackageDescriptor)) {
                    throw new DescriptorValidationException(fileDescriptor, '\"' + string2 + "\" is already defined (as something other than a package) in file \"" + genericDescriptor.getFile().getName() + "\".");
                }
            }
        }

        static void validateSymbolName(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            String string = genericDescriptor.getName();
            if (string.length() == 0) {
                throw new DescriptorValidationException(genericDescriptor, "Missing name.");
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_' || '0' <= c && c <= '9' && i > 0) continue;
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is not a valid identifier.");
            }
        }

        private static final class PackageDescriptor
        extends GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            @Override
            public Message toProto() {
                return this.file.toProto();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getFullName() {
                return this.fullName;
            }

            @Override
            public FileDescriptor getFile() {
                return this.file;
            }

            PackageDescriptor(String string, String string2, FileDescriptor fileDescriptor) {
                this.file = fileDescriptor;
                this.fullName = string2;
                this.name = string;
            }
        }

        static enum SearchFilter {
            TYPES_ONLY,
            AGGREGATES_ONLY,
            ALL_SYMBOLS;

        }
    }

    public static class DescriptorValidationException
    extends Exception {
        private static final long serialVersionUID = 5750205775490483148L;
        private final String name;
        private final Message proto;
        private final String description;

        public String getProblemSymbolName() {
            return this.name;
        }

        public Message getProblemProto() {
            return this.proto;
        }

        public String getDescription() {
            return this.description;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string) {
            super(genericDescriptor.getFullName() + ": " + string);
            this.name = genericDescriptor.getFullName();
            this.proto = genericDescriptor.toProto();
            this.description = string;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string, Throwable throwable) {
            this(genericDescriptor, string);
            this.initCause(throwable);
        }

        private DescriptorValidationException(FileDescriptor fileDescriptor, String string) {
            super(fileDescriptor.getName() + ": " + string);
            this.name = fileDescriptor.getName();
            this.proto = fileDescriptor.toProto();
            this.description = string;
        }
    }

    public static abstract class GenericDescriptor {
        GenericDescriptor parent;
        volatile DescriptorProtos.FeatureSet features;

        private GenericDescriptor() {
        }

        public abstract Message toProto();

        public abstract String getName();

        public abstract String getFullName();

        public abstract FileDescriptor getFile();

        void resolveFeatures(DescriptorProtos.FeatureSet featureSet) throws DescriptorValidationException {
            DescriptorProtos.FeatureSet.Builder builder;
            if (this.parent != null && featureSet.equals(DescriptorProtos.FeatureSet.getDefaultInstance()) && !this.hasInferredLegacyProtoFeatures()) {
                this.features = this.parent.features;
                this.validateFeatures();
                return;
            }
            if (this.parent == null) {
                DescriptorProtos.Edition edition = this.getFile().getEdition();
                builder = Descriptors.getEditionDefaults(edition).toBuilder();
            } else {
                builder = this.parent.features.toBuilder();
            }
            builder.mergeFrom(this.inferLegacyProtoFeatures());
            builder.mergeFrom(featureSet);
            this.features = Descriptors.internFeatures(builder.build());
            this.validateFeatures();
        }

        DescriptorProtos.FeatureSet inferLegacyProtoFeatures() {
            return DescriptorProtos.FeatureSet.getDefaultInstance();
        }

        boolean hasInferredLegacyProtoFeatures() {
            return false;
        }

        void validateFeatures() throws DescriptorValidationException {
        }
    }

    public static final class MethodDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private volatile DescriptorProtos.MethodOptions options;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.MethodDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public ServiceDescriptor getService() {
            return this.service;
        }

        public Descriptor getInputType() {
            return this.inputType;
        }

        public Descriptor getOutputType() {
            return this.outputType;
        }

        public boolean isClientStreaming() {
            return this.proto.getClientStreaming();
        }

        public boolean isServerStreaming() {
            return this.proto.getServerStreaming();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.MethodOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.MethodOptions methodOptions = this.proto.getOptions();
                if (methodOptions.hasFeatures()) {
                    methodOptions = methodOptions.toBuilder().clearFeatures().build();
                }
                MethodDescriptor methodDescriptor = this;
                synchronized (methodDescriptor) {
                    if (this.options == null) {
                        this.options = methodOptions;
                    }
                }
            }
            return this.options;
        }

        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptorProto, FileDescriptor fileDescriptor, ServiceDescriptor serviceDescriptor, int n) throws DescriptorValidationException {
            this.parent = serviceDescriptor;
            this.index = n;
            this.proto = methodDescriptorProto;
            this.file = fileDescriptor;
            this.service = serviceDescriptor;
            this.fullName = serviceDescriptor.getFullName() + '.' + methodDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor = this.getFile().pool.lookupSymbol(this.proto.getInputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getInputType() + "\" is not a message type.");
            }
            this.inputType = (Descriptor)genericDescriptor;
            GenericDescriptor genericDescriptor2 = this.getFile().pool.lookupSymbol(this.proto.getOutputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor2 instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getOutputType() + "\" is not a message type.");
            }
            this.outputType = (Descriptor)genericDescriptor2;
        }

        private void setProto(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) throws DescriptorValidationException {
            this.proto = methodDescriptorProto;
            this.options = null;
            this.resolveFeatures(methodDescriptorProto.getOptions().getFeatures());
        }
    }

    public static final class ServiceDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private volatile DescriptorProtos.ServiceOptions options;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.ServiceDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.ServiceOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.ServiceOptions serviceOptions = this.proto.getOptions();
                if (serviceOptions.hasFeatures()) {
                    serviceOptions = serviceOptions.toBuilder().clearFeatures().build();
                }
                ServiceDescriptor serviceDescriptor = this;
                synchronized (serviceDescriptor) {
                    if (this.options == null) {
                        this.options = serviceOptions;
                    }
                }
            }
            return this.options;
        }

        public List<MethodDescriptor> getMethods() {
            return Collections.unmodifiableList(Arrays.asList(this.methods));
        }

        public MethodDescriptor findMethodByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof MethodDescriptor) {
                return (MethodDescriptor)genericDescriptor;
            }
            return null;
        }

        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto, FileDescriptor fileDescriptor, int n) throws DescriptorValidationException {
            this.parent = fileDescriptor;
            this.index = n;
            this.proto = serviceDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, null, serviceDescriptorProto.getName());
            this.file = fileDescriptor;
            this.methods = new MethodDescriptor[serviceDescriptorProto.getMethodCount()];
            for (int i = 0; i < serviceDescriptorProto.getMethodCount(); ++i) {
                this.methods[i] = new MethodDescriptor(serviceDescriptorProto.getMethod(i), fileDescriptor, this, i);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
            for (MethodDescriptor methodDescriptor : this.methods) {
                methodDescriptor.resolveAllFeatures();
            }
        }

        private void crossLink() throws DescriptorValidationException {
            for (MethodDescriptor methodDescriptor : this.methods) {
                methodDescriptor.crossLink();
            }
        }

        private void setProto(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto) throws DescriptorValidationException {
            this.proto = serviceDescriptorProto;
            this.options = null;
            this.resolveFeatures(serviceDescriptorProto.getOptions().getFeatures());
            for (int i = 0; i < this.methods.length; ++i) {
                this.methods[i].setProto(serviceDescriptorProto.getMethod(i));
            }
        }
    }

    public static final class EnumValueDescriptor
    extends GenericDescriptor
    implements Internal.EnumLite {
        static final Comparator<EnumValueDescriptor> BY_NUMBER = new Comparator<EnumValueDescriptor>(){

            @Override
            public int compare(EnumValueDescriptor enumValueDescriptor, EnumValueDescriptor enumValueDescriptor2) {
                return Integer.valueOf(enumValueDescriptor.getNumber()).compareTo(enumValueDescriptor2.getNumber());
            }
        };
        static final NumberGetter<EnumValueDescriptor> NUMBER_GETTER = new NumberGetter<EnumValueDescriptor>(){

            @Override
            public int getNumber(EnumValueDescriptor enumValueDescriptor) {
                return enumValueDescriptor.getNumber();
            }
        };
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private volatile DescriptorProtos.EnumValueOptions options;
        private final String fullName;
        private final EnumDescriptor type;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumValueDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        public String toString() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.type.file;
        }

        public EnumDescriptor getType() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.EnumValueOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.EnumValueOptions enumValueOptions = this.proto.getOptions();
                if (enumValueOptions.hasFeatures()) {
                    enumValueOptions = enumValueOptions.toBuilder().clearFeatures().build();
                }
                EnumValueDescriptor enumValueDescriptor = this;
                synchronized (enumValueDescriptor) {
                    if (this.options == null) {
                        this.options = enumValueOptions;
                    }
                }
            }
            return this.options;
        }

        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto, FileDescriptor fileDescriptor, EnumDescriptor enumDescriptor, int n) throws DescriptorValidationException {
            this.parent = enumDescriptor;
            this.index = n;
            this.proto = enumValueDescriptorProto;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
        }

        private EnumValueDescriptor(EnumDescriptor enumDescriptor, Integer n) {
            String string = "UNKNOWN_ENUM_VALUE_" + enumDescriptor.getName() + "_" + n;
            DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto = DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(string).setNumber(n).build();
            this.parent = enumDescriptor;
            this.index = -1;
            this.proto = enumValueDescriptorProto;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
        }

        private void setProto(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto) throws DescriptorValidationException {
            this.proto = enumValueDescriptorProto;
            this.options = null;
            this.resolveFeatures(enumValueDescriptorProto.getOptions().getFeatures());
        }
    }

    public static final class EnumDescriptor
    extends GenericDescriptor
    implements Internal.EnumLiteMap<EnumValueDescriptor> {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private volatile DescriptorProtos.EnumOptions options;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final EnumValueDescriptor[] values;
        private final EnumValueDescriptor[] valuesSortedByNumber;
        private final int distinctNumbers;
        private Map<Integer, WeakReference<EnumValueDescriptor>> unknownValues = null;
        private ReferenceQueue<EnumValueDescriptor> cleanupQueue = null;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public boolean isClosed() {
            return this.features.getEnumType() == DescriptorProtos.FeatureSet.EnumType.CLOSED;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.EnumOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.EnumOptions enumOptions = this.proto.getOptions();
                if (enumOptions.hasFeatures()) {
                    enumOptions = enumOptions.toBuilder().clearFeatures().build();
                }
                EnumDescriptor enumDescriptor = this;
                synchronized (enumDescriptor) {
                    if (this.options == null) {
                        this.options = enumOptions;
                    }
                }
            }
            return this.options;
        }

        public List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        public boolean isReservedNumber(int n) {
            for (DescriptorProtos.EnumDescriptorProto.EnumReservedRange enumReservedRange : this.proto.getReservedRangeList()) {
                if (enumReservedRange.getStart() > n || n > enumReservedRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public boolean isReservedName(String string) {
            Internal.checkNotNull(string);
            for (String string2 : this.proto.getReservedNameList()) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public EnumValueDescriptor findValueByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof EnumValueDescriptor) {
                return (EnumValueDescriptor)genericDescriptor;
            }
            return null;
        }

        @Override
        public EnumValueDescriptor findValueByNumber(int n) {
            return (EnumValueDescriptor)Descriptors.binarySearch(this.valuesSortedByNumber, this.distinctNumbers, EnumValueDescriptor.NUMBER_GETTER, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EnumValueDescriptor findValueByNumberCreatingIfUnknown(int n) {
            EnumValueDescriptor enumValueDescriptor = this.findValueByNumber(n);
            if (enumValueDescriptor != null) {
                return enumValueDescriptor;
            }
            EnumDescriptor enumDescriptor = this;
            synchronized (enumDescriptor) {
                WeakReference weakReference;
                if (this.cleanupQueue == null) {
                    this.cleanupQueue = new ReferenceQueue();
                    this.unknownValues = new HashMap<Integer, WeakReference<EnumValueDescriptor>>();
                } else {
                    while ((weakReference = (UnknownEnumValueReference)this.cleanupQueue.poll()) != null) {
                        this.unknownValues.remove(((UnknownEnumValueReference)weakReference).number);
                    }
                }
                weakReference = this.unknownValues.get(n);
                EnumValueDescriptor enumValueDescriptor2 = enumValueDescriptor = weakReference == null ? null : (EnumValueDescriptor)weakReference.get();
                if (enumValueDescriptor == null) {
                    enumValueDescriptor = new EnumValueDescriptor(this, n);
                    this.unknownValues.put(n, new UnknownEnumValueReference(n, enumValueDescriptor));
                }
            }
            return enumValueDescriptor;
        }

        int getUnknownEnumValueDescriptorCount() {
            return this.unknownValues.size();
        }

        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto enumDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n) throws DescriptorValidationException {
            int n2;
            this.parent = descriptor == null ? fileDescriptor : descriptor;
            this.index = n;
            this.proto = enumDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, enumDescriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            if (enumDescriptorProto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.");
            }
            this.values = new EnumValueDescriptor[enumDescriptorProto.getValueCount()];
            for (n2 = 0; n2 < enumDescriptorProto.getValueCount(); ++n2) {
                this.values[n2] = new EnumValueDescriptor(enumDescriptorProto.getValue(n2), fileDescriptor, this, n2);
            }
            this.valuesSortedByNumber = (EnumValueDescriptor[])this.values.clone();
            Arrays.sort(this.valuesSortedByNumber, EnumValueDescriptor.BY_NUMBER);
            n2 = 0;
            for (int i = 1; i < enumDescriptorProto.getValueCount(); ++i) {
                EnumValueDescriptor enumValueDescriptor = this.valuesSortedByNumber[n2];
                EnumValueDescriptor enumValueDescriptor2 = this.valuesSortedByNumber[i];
                if (enumValueDescriptor.getNumber() == enumValueDescriptor2.getNumber()) continue;
                this.valuesSortedByNumber[++n2] = enumValueDescriptor2;
            }
            this.distinctNumbers = n2 + 1;
            Arrays.fill(this.valuesSortedByNumber, this.distinctNumbers, enumDescriptorProto.getValueCount(), null);
            fileDescriptor.pool.addSymbol(this);
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
            for (EnumValueDescriptor enumValueDescriptor : this.values) {
                enumValueDescriptor.resolveAllFeatures();
            }
        }

        private void setProto(DescriptorProtos.EnumDescriptorProto enumDescriptorProto) throws DescriptorValidationException {
            this.proto = enumDescriptorProto;
            this.options = null;
            this.resolveFeatures(enumDescriptorProto.getOptions().getFeatures());
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].setProto(enumDescriptorProto.getValue(i));
            }
        }

        private static class UnknownEnumValueReference
        extends WeakReference<EnumValueDescriptor> {
            private final int number;

            private UnknownEnumValueReference(int n, EnumValueDescriptor enumValueDescriptor) {
                super(enumValueDescriptor);
                this.number = n;
            }
        }
    }

    public static final class FieldDescriptor
    extends GenericDescriptor
    implements Comparable<FieldDescriptor>,
    FieldSet.FieldDescriptorLite<FieldDescriptor> {
        private static final NumberGetter<FieldDescriptor> NUMBER_GETTER = new NumberGetter<FieldDescriptor>(){

            @Override
            public int getNumber(FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getNumber();
            }
        };
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private volatile DescriptorProtos.FieldOptions options;
        private final String fullName;
        private String jsonName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private final boolean isProto3Optional;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private OneofDescriptor containingOneof;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.FieldDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public String getJsonName() {
            String string = this.jsonName;
            if (string != null) {
                return string;
            }
            if (this.proto.hasJsonName()) {
                this.jsonName = this.proto.getJsonName();
                return this.jsonName;
            }
            this.jsonName = FieldDescriptor.fieldNameToJsonName(this.proto.getName());
            return this.jsonName;
        }

        public JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Type getType() {
            if (this.type == Type.MESSAGE && this.features != null && this.features.getMessageEncoding() == DescriptorProtos.FeatureSet.MessageEncoding.DELIMITED) {
                return Type.GROUP;
            }
            return this.type;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public boolean needsUtf8Check() {
            if (this.type != Type.STRING) {
                return false;
            }
            if (this.getContainingType().toProto().getOptions().getMapEntry()) {
                return true;
            }
            if (this.features.getExtension(JavaFeaturesProto.java).getUtf8Validation().equals(JavaFeaturesProto.JavaFeatures.Utf8Validation.VERIFY)) {
                return true;
            }
            return this.features.getUtf8Validation().equals(DescriptorProtos.FeatureSet.Utf8Validation.VERIFY);
        }

        public boolean isMapField() {
            return this.getType() == Type.MESSAGE && this.isRepeated() && this.getMessageType().toProto().getOptions().getMapEntry();
        }

        public boolean isRequired() {
            return this.features.getFieldPresence() == DescriptorProtos.FeatureSet.FieldPresence.LEGACY_REQUIRED;
        }

        public boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL && this.features.getFieldPresence() != DescriptorProtos.FeatureSet.FieldPresence.LEGACY_REQUIRED;
        }

        @Override
        public boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public boolean isPacked() {
            if (!this.isPackable()) {
                return false;
            }
            return this.features.getRepeatedFieldEncoding().equals(DescriptorProtos.FeatureSet.RepeatedFieldEncoding.PACKED);
        }

        public boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public boolean hasDefaultValue() {
            return this.proto.hasDefaultValue();
        }

        public Object getDefaultValue() {
            if (this.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.FieldOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.FieldOptions fieldOptions = this.proto.getOptions();
                if (fieldOptions.hasFeatures()) {
                    fieldOptions = fieldOptions.toBuilder().clearFeatures().build();
                }
                FieldDescriptor fieldDescriptor = this;
                synchronized (fieldDescriptor) {
                    if (this.options == null) {
                        this.options = fieldOptions;
                    }
                }
            }
            return this.options;
        }

        public boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public OneofDescriptor getContainingOneof() {
            return this.containingOneof;
        }

        public OneofDescriptor getRealContainingOneof() {
            return this.containingOneof != null && !this.containingOneof.isSynthetic() ? this.containingOneof : null;
        }

        boolean hasOptionalKeyword() {
            return this.isProto3Optional || this.file.getEdition() == DescriptorProtos.Edition.EDITION_PROTO2 && this.isOptional() && this.getContainingOneof() == null;
        }

        public boolean hasPresence() {
            if (this.isRepeated()) {
                return false;
            }
            return this.getType() == Type.MESSAGE || this.getType() == Type.GROUP || this.getContainingOneof() != null || this.features.getFieldPresence() != DescriptorProtos.FeatureSet.FieldPresence.IMPLICIT;
        }

        public Descriptor getExtensionScope() {
            if (!this.isExtension()) {
                throw new UnsupportedOperationException(String.format("This field is not an extension. (%s)", this.fullName));
            }
            return this.extensionScope;
        }

        public Descriptor getMessageType() {
            if (this.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException(String.format("This field is not of message type. (%s)", this.fullName));
            }
            return this.messageType;
        }

        public EnumDescriptor getEnumType() {
            if (this.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException(String.format("This field is not of enum type. (%s)", this.fullName));
            }
            return this.enumType;
        }

        public boolean legacyEnumFieldTreatedAsClosed() {
            if (this.getFile().getDependencies().isEmpty()) {
                return this.getType() == Type.ENUM && this.enumType.isClosed();
            }
            return this.getType() == Type.ENUM && (this.features.getExtension(JavaFeaturesProto.java).getLegacyClosedEnum() || this.enumType.isClosed());
        }

        @Override
        public int compareTo(FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.containingType != this.containingType) {
                throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
            }
            return this.getNumber() - fieldDescriptor.getNumber();
        }

        public String toString() {
            return this.getFullName();
        }

        private static String fieldNameToJsonName(String string) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '_') {
                    bl = true;
                    continue;
                }
                if (bl) {
                    if ('a' <= c && c <= 'z') {
                        c = (char)(c - 97 + 65);
                    }
                    stringBuilder.append(c);
                    bl = false;
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n, boolean bl) throws DescriptorValidationException {
            this.parent = descriptor;
            this.index = n;
            this.proto = fieldDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, fieldDescriptorProto.getName());
            this.file = fileDescriptor;
            if (fieldDescriptorProto.hasType()) {
                this.type = Type.valueOf(fieldDescriptorProto.getType());
            }
            this.isProto3Optional = fieldDescriptorProto.getProto3Optional();
            if (this.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.");
            }
            if (bl) {
                if (!fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.");
                }
                this.containingType = null;
                this.extensionScope = descriptor != null ? descriptor : null;
                if (fieldDescriptorProto.hasOneofIndex()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.");
                }
                this.containingOneof = null;
            } else {
                if (fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.");
                }
                this.containingType = descriptor;
                if (fieldDescriptorProto.hasOneofIndex()) {
                    if (fieldDescriptorProto.getOneofIndex() < 0 || fieldDescriptorProto.getOneofIndex() >= descriptor.toProto().getOneofDeclCount()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index is out of range for type " + descriptor.getName());
                    }
                    this.containingOneof = descriptor.getOneofs().get(fieldDescriptorProto.getOneofIndex());
                    this.containingOneof.fieldCount++;
                } else {
                    this.containingOneof = null;
                }
                this.extensionScope = null;
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
        }

        @Override
        DescriptorProtos.FeatureSet inferLegacyProtoFeatures() {
            DescriptorProtos.FeatureSet.Builder builder = DescriptorProtos.FeatureSet.newBuilder();
            if (this.getFile().getEdition().getNumber() >= DescriptorProtos.Edition.EDITION_2023.getNumber()) {
                return builder.build();
            }
            if (this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED) {
                builder.setFieldPresence(DescriptorProtos.FeatureSet.FieldPresence.LEGACY_REQUIRED);
            }
            if (this.proto.getType() == DescriptorProtos.FieldDescriptorProto.Type.TYPE_GROUP) {
                builder.setMessageEncoding(DescriptorProtos.FeatureSet.MessageEncoding.DELIMITED);
            }
            if (this.getFile().getEdition() == DescriptorProtos.Edition.EDITION_PROTO2 && this.proto.getOptions().getPacked()) {
                builder.setRepeatedFieldEncoding(DescriptorProtos.FeatureSet.RepeatedFieldEncoding.PACKED);
            }
            if (this.getFile().getEdition() == DescriptorProtos.Edition.EDITION_PROTO3 && this.proto.getOptions().hasPacked() && !this.proto.getOptions().getPacked()) {
                builder.setRepeatedFieldEncoding(DescriptorProtos.FeatureSet.RepeatedFieldEncoding.EXPANDED);
            }
            return builder.build();
        }

        @Override
        boolean hasInferredLegacyProtoFeatures() {
            if (this.getFile().getEdition().getNumber() >= DescriptorProtos.Edition.EDITION_2023.getNumber()) {
                return false;
            }
            if (this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED) {
                return true;
            }
            if (this.proto.getType() == DescriptorProtos.FieldDescriptorProto.Type.TYPE_GROUP) {
                return true;
            }
            if (this.proto.getOptions().getPacked()) {
                return true;
            }
            return this.getFile().getEdition() == DescriptorProtos.Edition.EDITION_PROTO3 && this.proto.getOptions().hasPacked() && !this.proto.getOptions().getPacked();
        }

        @Override
        void validateFeatures() throws DescriptorValidationException {
            if (this.containingType != null && this.containingType.toProto().getOptions().getMessageSetWireFormat() && this.isExtension() && (!this.isOptional() || this.getType() != Type.MESSAGE)) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Extensions of MessageSets must be optional messages.");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            if (this.proto.hasExtendee()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getExtendee(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!(genericDescriptor instanceof Descriptor)) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getExtendee() + "\" is not a message type.");
                }
                this.containingType = (Descriptor)genericDescriptor;
                if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.getContainingType().getFullName() + "\" does not declare " + this.getNumber() + " as an extension number.");
                }
            }
            if (this.proto.hasTypeName()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getTypeName(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!this.proto.hasType()) {
                    if (genericDescriptor instanceof Descriptor) {
                        this.type = Type.MESSAGE;
                    } else {
                        if (!(genericDescriptor instanceof EnumDescriptor)) throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a type.");
                        this.type = Type.ENUM;
                    }
                }
                if (this.getJavaType() == JavaType.MESSAGE) {
                    if (!(genericDescriptor instanceof Descriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a message type.");
                    }
                    this.messageType = (Descriptor)genericDescriptor;
                    if (this.proto.hasDefaultValue()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Messages can't have default values.");
                    }
                } else {
                    if (this.getJavaType() != JavaType.ENUM) throw new DescriptorValidationException((GenericDescriptor)this, "Field with primitive type has type_name.");
                    if (!(genericDescriptor instanceof EnumDescriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not an enum type.");
                    }
                    this.enumType = (EnumDescriptor)genericDescriptor;
                }
            } else if (this.getJavaType() == JavaType.MESSAGE || this.getJavaType() == JavaType.ENUM) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field with message or enum type missing type_name.");
            }
            if (this.proto.getOptions().getPacked() && !this.isPackable()) {
                throw new DescriptorValidationException((GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.");
            }
            if (this.proto.hasDefaultValue()) {
                if (this.isRepeated()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "Repeated fields cannot have default values.");
                }
                try {
                    switch (this.getType()) {
                        case INT32: 
                        case SINT32: 
                        case SFIXED32: {
                            this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                            return;
                        }
                        case UINT32: 
                        case FIXED32: {
                            this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                            return;
                        }
                        case INT64: 
                        case SINT64: 
                        case SFIXED64: {
                            this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                            return;
                        }
                        case UINT64: 
                        case FIXED64: {
                            this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                            return;
                        }
                        case FLOAT: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                return;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                return;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Float.valueOf(Float.NaN);
                                return;
                            }
                            this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                            return;
                        }
                        case DOUBLE: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Double.POSITIVE_INFINITY;
                                return;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Double.NEGATIVE_INFINITY;
                                return;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Double.NaN;
                                return;
                            }
                            this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                            return;
                        }
                        case BOOL: {
                            this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                            return;
                        }
                        case STRING: {
                            this.defaultValue = this.proto.getDefaultValue();
                            return;
                        }
                        case BYTES: {
                            try {
                                this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                                return;
                            }
                            catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                                throw new DescriptorValidationException(this, "Couldn't parse default value: " + invalidEscapeSequenceException.getMessage(), invalidEscapeSequenceException);
                            }
                        }
                        case ENUM: {
                            this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                            if (this.defaultValue != null) return;
                            throw new DescriptorValidationException((GenericDescriptor)this, "Unknown enum default value: \"" + this.proto.getDefaultValue() + '\"');
                        }
                        case MESSAGE: 
                        case GROUP: {
                            throw new DescriptorValidationException((GenericDescriptor)this, "Message type had default value.");
                        }
                    }
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DescriptorValidationException(this, "Could not parse default value: \"" + this.proto.getDefaultValue() + '\"', numberFormatException);
                }
            } else if (this.isRepeated()) {
                this.defaultValue = Collections.emptyList();
                return;
            } else {
                switch (this.getJavaType()) {
                    case ENUM: {
                        this.defaultValue = this.enumType.getValues().get(0);
                        return;
                    }
                    case MESSAGE: {
                        this.defaultValue = null;
                        return;
                    }
                    default: {
                        this.defaultValue = this.getJavaType().defaultDefault;
                    }
                }
            }
        }

        private void setProto(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto) throws DescriptorValidationException {
            this.proto = fieldDescriptorProto;
            this.options = null;
            this.resolveFeatures(fieldDescriptorProto.getOptions().getFeatures());
        }

        @Override
        public MessageLite.Builder internalMergeFrom(MessageLite.Builder builder, MessageLite messageLite) {
            return ((Message.Builder)builder).mergeFrom((Message)messageLite);
        }

        static {
            if (Type.types.length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Descriptors.java wasn't updated.");
            }
        }

        public static enum JavaType {
            INT(0),
            LONG(0L),
            FLOAT(Float.valueOf(0.0f)),
            DOUBLE(0.0),
            BOOLEAN(false),
            STRING(""),
            BYTE_STRING(ByteString.EMPTY),
            ENUM(null),
            MESSAGE(null);

            private final Object defaultDefault;

            private JavaType(Object object) {
                this.defaultDefault = object;
            }
        }

        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private static final Type[] types;
            private final JavaType javaType;

            private Type(JavaType javaType) {
                this.javaType = javaType;
            }

            public DescriptorProtos.FieldDescriptorProto.Type toProto() {
                return DescriptorProtos.FieldDescriptorProto.Type.forNumber(this.ordinal() + 1);
            }

            public JavaType getJavaType() {
                return this.javaType;
            }

            public static Type valueOf(DescriptorProtos.FieldDescriptorProto.Type type) {
                return types[type.getNumber() - 1];
            }

            static {
                types = Type.values();
            }
        }
    }

    public static final class Descriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private volatile DescriptorProtos.MessageOptions options;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] fieldsSortedByNumber;
        private final FieldDescriptor[] extensions;
        private final OneofDescriptor[] oneofs;
        private final int realOneofCount;
        private final int[] extensionRangeLowerBounds;
        private final int[] extensionRangeUpperBounds;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.MessageOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.MessageOptions messageOptions = this.proto.getOptions();
                if (messageOptions.hasFeatures()) {
                    messageOptions = messageOptions.toBuilder().clearFeatures().build();
                }
                Descriptor descriptor = this;
                synchronized (descriptor) {
                    if (this.options == null) {
                        this.options = messageOptions;
                    }
                }
            }
            return this.options;
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public List<OneofDescriptor> getOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs));
        }

        public List<OneofDescriptor> getRealOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs).subList(0, this.realOneofCount));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public boolean isExtensionNumber(int n) {
            int n2 = Arrays.binarySearch(this.extensionRangeLowerBounds, n);
            if (n2 < 0) {
                n2 = ~n2 - 1;
            }
            return n2 >= 0 && n < this.extensionRangeUpperBounds[n2];
        }

        public boolean isReservedNumber(int n) {
            for (DescriptorProtos.DescriptorProto.ReservedRange reservedRange : this.proto.getReservedRangeList()) {
                if (reservedRange.getStart() > n || n >= reservedRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public boolean isReservedName(String string) {
            Internal.checkNotNull(string);
            for (String string2 : this.proto.getReservedNameList()) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean isExtendable() {
            return !this.proto.getExtensionRangeList().isEmpty();
        }

        public FieldDescriptor findFieldByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof FieldDescriptor) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findFieldByNumber(int n) {
            return (FieldDescriptor)Descriptors.binarySearch(this.fieldsSortedByNumber, this.fieldsSortedByNumber.length, FieldDescriptor.NUMBER_GETTER, n);
        }

        public Descriptor findNestedTypeByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof Descriptor) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof EnumDescriptor) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        Descriptor(String string) throws DescriptorValidationException {
            String string2 = string;
            String string3 = "";
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string2 = string.substring(n + 1);
                string3 = string.substring(0, n);
            }
            this.index = 0;
            this.proto = DescriptorProtos.DescriptorProto.newBuilder().setName(string2).addExtensionRange(DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder().setStart(1).setEnd(0x20000000).build()).build();
            this.fullName = string;
            this.containingType = null;
            this.nestedTypes = EMPTY_DESCRIPTORS;
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.fields = EMPTY_FIELD_DESCRIPTORS;
            this.fieldsSortedByNumber = EMPTY_FIELD_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.oneofs = EMPTY_ONEOF_DESCRIPTORS;
            this.realOneofCount = 0;
            this.file = new FileDescriptor(string3, this);
            this.parent = this.file;
            this.extensionRangeLowerBounds = new int[]{1};
            this.extensionRangeUpperBounds = new int[]{0x20000000};
        }

        /*
         * WARNING - void declaration
         */
        private Descriptor(DescriptorProtos.DescriptorProto descriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n) throws DescriptorValidationException {
            int n2;
            this.parent = descriptor == null ? fileDescriptor : descriptor;
            this.index = n;
            this.proto = descriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, descriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            this.oneofs = descriptorProto.getOneofDeclCount() > 0 ? new OneofDescriptor[descriptorProto.getOneofDeclCount()] : EMPTY_ONEOF_DESCRIPTORS;
            for (n2 = 0; n2 < descriptorProto.getOneofDeclCount(); ++n2) {
                this.oneofs[n2] = new OneofDescriptor(descriptorProto.getOneofDecl(n2), fileDescriptor, this, n2);
            }
            this.nestedTypes = descriptorProto.getNestedTypeCount() > 0 ? new Descriptor[descriptorProto.getNestedTypeCount()] : EMPTY_DESCRIPTORS;
            for (n2 = 0; n2 < descriptorProto.getNestedTypeCount(); ++n2) {
                this.nestedTypes[n2] = new Descriptor(descriptorProto.getNestedType(n2), fileDescriptor, this, n2);
            }
            this.enumTypes = descriptorProto.getEnumTypeCount() > 0 ? new EnumDescriptor[descriptorProto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (n2 = 0; n2 < descriptorProto.getEnumTypeCount(); ++n2) {
                this.enumTypes[n2] = new EnumDescriptor(descriptorProto.getEnumType(n2), fileDescriptor, this, n2);
            }
            this.fields = descriptorProto.getFieldCount() > 0 ? new FieldDescriptor[descriptorProto.getFieldCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n2 = 0; n2 < descriptorProto.getFieldCount(); ++n2) {
                this.fields[n2] = new FieldDescriptor(descriptorProto.getField(n2), fileDescriptor, this, n2, false);
            }
            this.fieldsSortedByNumber = descriptorProto.getFieldCount() > 0 ? (FieldDescriptor[])this.fields.clone() : EMPTY_FIELD_DESCRIPTORS;
            this.extensions = descriptorProto.getExtensionCount() > 0 ? new FieldDescriptor[descriptorProto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n2 = 0; n2 < descriptorProto.getExtensionCount(); ++n2) {
                this.extensions[n2] = new FieldDescriptor(descriptorProto.getExtension(n2), fileDescriptor, this, n2, true);
            }
            for (n2 = 0; n2 < descriptorProto.getOneofDeclCount(); ++n2) {
                OneofDescriptor.access$2802(this.oneofs[n2], new FieldDescriptor[this.oneofs[n2].getFieldCount()]);
                this.oneofs[n2].fieldCount = 0;
            }
            for (n2 = 0; n2 < descriptorProto.getFieldCount(); ++n2) {
                OneofDescriptor object = this.fields[n2].getContainingOneof();
                if (object == null) continue;
                ((OneofDescriptor)object).fields[((OneofDescriptor)object).fieldCount++] = this.fields[n2];
            }
            n2 = 0;
            for (OneofDescriptor oneofDescriptor : this.oneofs) {
                if (oneofDescriptor.isSynthetic()) {
                    ++n2;
                    continue;
                }
                if (n2 <= 0) continue;
                throw new DescriptorValidationException((GenericDescriptor)this, "Synthetic oneofs must come last.");
            }
            this.realOneofCount = this.oneofs.length - n2;
            fileDescriptor.pool.addSymbol(this);
            if (descriptorProto.getExtensionRangeCount() > 0) {
                this.extensionRangeLowerBounds = new int[descriptorProto.getExtensionRangeCount()];
                this.extensionRangeUpperBounds = new int[descriptorProto.getExtensionRangeCount()];
                boolean bl = false;
                for (DescriptorProtos.DescriptorProto.ExtensionRange extensionRange : descriptorProto.getExtensionRangeList()) {
                    void var6_9;
                    this.extensionRangeLowerBounds[var6_9] = extensionRange.getStart();
                    this.extensionRangeUpperBounds[var6_9] = extensionRange.getEnd();
                    ++var6_9;
                }
                Arrays.sort(this.extensionRangeLowerBounds);
                Arrays.sort(this.extensionRangeUpperBounds);
            } else {
                this.extensionRangeLowerBounds = EMPTY_INT_ARRAY;
                this.extensionRangeUpperBounds = EMPTY_INT_ARRAY;
            }
        }

        private void resolveAllFeatures() throws DescriptorValidationException {
            this.resolveFeatures(this.proto.getOptions().getFeatures());
            for (Descriptor genericDescriptor : this.nestedTypes) {
                genericDescriptor.resolveAllFeatures();
            }
            for (GenericDescriptor genericDescriptor : this.enumTypes) {
                ((EnumDescriptor)genericDescriptor).resolveAllFeatures();
            }
            for (GenericDescriptor genericDescriptor : this.fields) {
                ((FieldDescriptor)genericDescriptor).resolveAllFeatures();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).resolveAllFeatures();
            }
            for (GenericDescriptor genericDescriptor : this.oneofs) {
                ((OneofDescriptor)genericDescriptor).resolveAllFeatures();
            }
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.nestedTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.fields) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
            Arrays.sort(this.fieldsSortedByNumber);
            this.validateNoDuplicateFieldNumbers();
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void validateNoDuplicateFieldNumbers() throws DescriptorValidationException {
            int n = 0;
            while (n + 1 < this.fieldsSortedByNumber.length) {
                FieldDescriptor fieldDescriptor = this.fieldsSortedByNumber[n];
                FieldDescriptor fieldDescriptor2 = this.fieldsSortedByNumber[n + 1];
                if (fieldDescriptor.getNumber() == fieldDescriptor2.getNumber()) {
                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor2, "Field number " + fieldDescriptor2.getNumber() + " has already been used in \"" + fieldDescriptor2.getContainingType().getFullName() + "\" by field \"" + fieldDescriptor.getName() + "\".");
                }
                ++n;
            }
        }

        private void setProto(DescriptorProtos.DescriptorProto descriptorProto) throws DescriptorValidationException {
            int n;
            this.proto = descriptorProto;
            this.options = null;
            this.resolveFeatures(descriptorProto.getOptions().getFeatures());
            for (n = 0; n < this.nestedTypes.length; ++n) {
                this.nestedTypes[n].setProto(descriptorProto.getNestedType(n));
            }
            for (n = 0; n < this.oneofs.length; ++n) {
                this.oneofs[n].setProto(descriptorProto.getOneofDecl(n));
            }
            for (n = 0; n < this.enumTypes.length; ++n) {
                this.enumTypes[n].setProto(descriptorProto.getEnumType(n));
            }
            for (n = 0; n < this.fields.length; ++n) {
                this.fields[n].setProto(descriptorProto.getField(n));
            }
            for (n = 0; n < this.extensions.length; ++n) {
                this.extensions[n].setProto(descriptorProto.getExtension(n));
            }
        }
    }

    public static final class FileDescriptor
    extends GenericDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private volatile DescriptorProtos.FileOptions options;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        @Override
        public DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this;
        }

        @Override
        public String getFullName() {
            return this.proto.getName();
        }

        public String getPackage() {
            return this.proto.getPackage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorProtos.FileOptions getOptions() {
            if (this.options == null) {
                DescriptorProtos.FileOptions fileOptions = this.proto.getOptions();
                if (fileOptions.hasFeatures()) {
                    fileOptions = fileOptions.toBuilder().clearFeatures().build();
                }
                FileDescriptor fileDescriptor = this;
                synchronized (fileDescriptor) {
                    if (this.options == null) {
                        this.options = fileOptions;
                    }
                }
            }
            return this.options;
        }

        public List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public List<ServiceDescriptor> getServices() {
            return Collections.unmodifiableList(Arrays.asList(this.services));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.dependencies));
        }

        public List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        DescriptorProtos.Edition getEdition() {
            switch (this.proto.getSyntax()) {
                case "editions": {
                    return this.proto.getEdition();
                }
                case "proto3": {
                    return DescriptorProtos.Edition.EDITION_PROTO3;
                }
            }
            return DescriptorProtos.Edition.EDITION_PROTO2;
        }

        public void copyHeadingTo(DescriptorProtos.FileDescriptorProto.Builder builder) {
            builder.setName(this.getName()).setSyntax(this.proto.getSyntax());
            if (!this.getPackage().isEmpty()) {
                builder.setPackage(this.getPackage());
            }
            if (this.proto.getSyntax().equals("editions")) {
                builder.setEdition(this.proto.getEdition());
            }
            if (this.proto.hasOptions() && !this.proto.getOptions().equals(DescriptorProtos.FileOptions.getDefaultInstance())) {
                builder.setOptions(this.proto.getOptions());
            }
        }

        public Descriptor findMessageTypeByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof Descriptor && genericDescriptor.getFile() == this) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof EnumDescriptor && genericDescriptor.getFile() == this) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        public ServiceDescriptor findServiceByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof ServiceDescriptor && genericDescriptor.getFile() == this) {
                return (ServiceDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findExtensionByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof FieldDescriptor && genericDescriptor.getFile() == this) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray) throws DescriptorValidationException {
            return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, false);
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, boolean bl) throws DescriptorValidationException {
            return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, bl, false);
        }

        private static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, boolean bl, boolean bl2) throws DescriptorValidationException {
            DescriptorPool descriptorPool = new DescriptorPool(fileDescriptorArray, bl);
            FileDescriptor fileDescriptor = new FileDescriptor(fileDescriptorProto, fileDescriptorArray, descriptorPool, bl);
            fileDescriptor.crossLink();
            if (!bl2) {
                fileDescriptor.resolveAllFeaturesInternal();
            }
            return fileDescriptor;
        }

        private static byte[] latin1Cat(String[] stringArray) {
            if (stringArray.length == 1) {
                return stringArray[0].getBytes(Internal.ISO_8859_1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString().getBytes(Internal.ISO_8859_1);
        }

        private static FileDescriptor[] findDescriptors(Class<?> clazz, String[] stringArray, String[] stringArray2) {
            ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Class<?> clazz2 = clazz.getClassLoader().loadClass(stringArray[i]);
                    arrayList.add((FileDescriptor)clazz2.getField("descriptor").get(null));
                    continue;
                }
                catch (Exception exception) {
                    logger.warning("Descriptors for \"" + stringArray2[i] + "\" can not be found.");
                }
            }
            return arrayList.toArray(new FileDescriptor[0]);
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] stringArray, FileDescriptor[] fileDescriptorArray) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(stringArray);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, true, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] stringArray, Class<?> clazz, String[] stringArray2, String[] stringArray3) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(clazz, stringArray2, stringArray3);
            return FileDescriptor.internalBuildGeneratedFileFrom(stringArray, fileDescriptorArray);
        }

        public static void internalUpdateFileDescriptor(FileDescriptor fileDescriptor, ExtensionRegistry extensionRegistry) {
            ByteString byteString = fileDescriptor.proto.toByteString();
            try {
                DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byteString, (ExtensionRegistryLite)extensionRegistry);
                fileDescriptor.setProto(fileDescriptorProto);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
        }

        private FileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, DescriptorPool descriptorPool, boolean bl) throws DescriptorValidationException {
            int n;
            this.pool = descriptorPool;
            this.proto = fileDescriptorProto;
            this.dependencies = (FileDescriptor[])fileDescriptorArray.clone();
            HashMap<String, FileDescriptor> hashMap = new HashMap<String, FileDescriptor>();
            for (FileDescriptor object : fileDescriptorArray) {
                hashMap.put(object.getName(), object);
            }
            ArrayList arrayList = new ArrayList();
            for (n = 0; n < fileDescriptorProto.getPublicDependencyCount(); ++n) {
                int n2 = fileDescriptorProto.getPublicDependency(n);
                if (n2 < 0 || n2 >= fileDescriptorProto.getDependencyCount()) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.");
                }
                String string = fileDescriptorProto.getDependency(n2);
                FileDescriptor fileDescriptor = (FileDescriptor)hashMap.get(string);
                if (fileDescriptor == null) {
                    if (bl) continue;
                    throw new DescriptorValidationException(this, "Invalid public dependency: " + string);
                }
                arrayList.add(fileDescriptor);
            }
            this.publicDependencies = new FileDescriptor[arrayList.size()];
            arrayList.toArray(this.publicDependencies);
            descriptorPool.addPackage(this.getPackage(), this);
            this.messageTypes = fileDescriptorProto.getMessageTypeCount() > 0 ? new Descriptor[fileDescriptorProto.getMessageTypeCount()] : EMPTY_DESCRIPTORS;
            for (n = 0; n < fileDescriptorProto.getMessageTypeCount(); ++n) {
                this.messageTypes[n] = new Descriptor(fileDescriptorProto.getMessageType(n), this, null, n);
            }
            this.enumTypes = fileDescriptorProto.getEnumTypeCount() > 0 ? new EnumDescriptor[fileDescriptorProto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (n = 0; n < fileDescriptorProto.getEnumTypeCount(); ++n) {
                this.enumTypes[n] = new EnumDescriptor(fileDescriptorProto.getEnumType(n), this, null, n);
            }
            this.services = fileDescriptorProto.getServiceCount() > 0 ? new ServiceDescriptor[fileDescriptorProto.getServiceCount()] : EMPTY_SERVICE_DESCRIPTORS;
            for (n = 0; n < fileDescriptorProto.getServiceCount(); ++n) {
                this.services[n] = new ServiceDescriptor(fileDescriptorProto.getService(n), this, n);
            }
            this.extensions = fileDescriptorProto.getExtensionCount() > 0 ? new FieldDescriptor[fileDescriptorProto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n = 0; n < fileDescriptorProto.getExtensionCount(); ++n) {
                this.extensions[n] = new FieldDescriptor(fileDescriptorProto.getExtension(n), this, null, n, true);
            }
        }

        FileDescriptor(String string, Descriptor descriptor) throws DescriptorValidationException {
            this.parent = null;
            this.pool = new DescriptorPool(new FileDescriptor[0], true);
            this.proto = DescriptorProtos.FileDescriptorProto.newBuilder().setName(descriptor.getFullName() + ".placeholder.proto").setPackage(string).addMessageType(descriptor.toProto()).build();
            this.dependencies = new FileDescriptor[0];
            this.publicDependencies = new FileDescriptor[0];
            this.messageTypes = new Descriptor[]{descriptor};
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.services = EMPTY_SERVICE_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.pool.addPackage(string, this);
            this.pool.addSymbol(descriptor);
        }

        public void resolveAllFeaturesImmutable() {
            try {
                this.resolveAllFeaturesInternal();
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid features for \"" + this.proto.getName() + "\".", descriptorValidationException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveAllFeaturesInternal() throws DescriptorValidationException {
            if (this.features != null) {
                return;
            }
            FileDescriptor fileDescriptor = this;
            synchronized (fileDescriptor) {
                if (this.features != null) {
                    return;
                }
                this.resolveFeatures(this.proto.getOptions().getFeatures());
                for (Descriptor genericDescriptor : this.messageTypes) {
                    genericDescriptor.resolveAllFeatures();
                }
                for (GenericDescriptor genericDescriptor : this.enumTypes) {
                    ((EnumDescriptor)genericDescriptor).resolveAllFeatures();
                }
                for (GenericDescriptor genericDescriptor : this.services) {
                    ((ServiceDescriptor)genericDescriptor).resolveAllFeatures();
                }
                for (GenericDescriptor genericDescriptor : this.extensions) {
                    ((FieldDescriptor)genericDescriptor).resolveAllFeatures();
                }
            }
        }

        @Override
        DescriptorProtos.FeatureSet inferLegacyProtoFeatures() {
            DescriptorProtos.FeatureSet.Builder builder = DescriptorProtos.FeatureSet.newBuilder();
            if (this.getEdition().getNumber() >= DescriptorProtos.Edition.EDITION_2023.getNumber()) {
                return builder.build();
            }
            if (this.getEdition() == DescriptorProtos.Edition.EDITION_PROTO2 && this.proto.getOptions().getJavaStringCheckUtf8()) {
                builder.setExtension(JavaFeaturesProto.java, JavaFeaturesProto.JavaFeatures.newBuilder().setUtf8Validation(JavaFeaturesProto.JavaFeatures.Utf8Validation.VERIFY).build());
            }
            return builder.build();
        }

        @Override
        boolean hasInferredLegacyProtoFeatures() {
            if (this.getEdition().getNumber() >= DescriptorProtos.Edition.EDITION_2023.getNumber()) {
                return false;
            }
            return this.getEdition() == DescriptorProtos.Edition.EDITION_PROTO2 && this.proto.getOptions().getJavaStringCheckUtf8();
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.messageTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.services) {
                ((ServiceDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private synchronized void setProto(DescriptorProtos.FileDescriptorProto fileDescriptorProto) {
            this.proto = fileDescriptorProto;
            this.options = null;
            try {
                int n;
                this.resolveFeatures(fileDescriptorProto.getOptions().getFeatures());
                for (n = 0; n < this.messageTypes.length; ++n) {
                    this.messageTypes[n].setProto(fileDescriptorProto.getMessageType(n));
                }
                for (n = 0; n < this.enumTypes.length; ++n) {
                    this.enumTypes[n].setProto(fileDescriptorProto.getEnumType(n));
                }
                for (n = 0; n < this.services.length; ++n) {
                    this.services[n].setProto(fileDescriptorProto.getService(n));
                }
                for (n = 0; n < this.extensions.length; ++n) {
                    this.extensions[n].setProto(fileDescriptorProto.getExtension(n));
                }
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid features for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
        }

        @Deprecated
        public static interface InternalDescriptorAssigner {
            public ExtensionRegistry assignDescriptors(FileDescriptor var1);
        }
    }
}

